/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.datafixers.util.Pair;
import com.terraformersmc.biolith.impl.biome.BiomeCoordinator;
import com.terraformersmc.biolith.impl.biome.DimensionBiomePlacement;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverBlock;
import mod.bluestaggo.modernerbeta.api.world.cavebiome.CaveBiomeProvider;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ModernBetaBiomeSource.class})
public abstract class MixinMBBiomeSource
extends BiomeSource {
    @Nullable
    public Climate.ParameterList<Holder<Biome>> biolith$getBiomeEntries() {
        return new Climate.ParameterList(this.possibleBiomes().stream().map(biomeEntry -> Pair.of((Object)DimensionBiomePlacement.OUT_OF_RANGE, (Object)biomeEntry)).toList());
    }

    @WrapOperation(method={"getNoiseBiome(IIILnet/minecraft/world/level/biome/Climate$Sampler;)Lnet/minecraft/core/Holder;", "getOceanBiome(III)Lnet/minecraft/core/Holder;", "getDeepOceanBiome(III)Lnet/minecraft/core/Holder;", "getCaveBiome(III)Lnet/minecraft/core/Holder;", "getBiomeForSpawn(III)Lnet/minecraft/core/Holder;", "getBiomeForHeightGen(III)Lmod/bluestaggo/modernerbeta/world/biome/provider/fractal/BiomeInfo;"}, at={@At(value="INVOKE", target="Lmod/bluestaggo/modernerbeta/api/world/biome/BiomeProvider;getBiome(III)Lnet/minecraft/core/Holder;")})
    private Holder<Biome> biolith$getBiome(BiomeProvider instance, int biomeX, int biomeY, int biomeZ, Operation<Holder<Biome>> operation) {
        Holder original = (Holder)operation.call(new Object[]{instance, biomeX, biomeY, biomeZ});
        return BiomeCoordinator.OVERWORLD.getReplacementEntry(biomeX, biomeY, biomeZ, (Holder<Biome>)original);
    }

    @WrapOperation(method={"getCaveBiome(III)Lnet/minecraft/core/Holder;"}, at={@At(value="INVOKE", target="Lmod/bluestaggo/modernerbeta/api/world/cavebiome/CaveBiomeProvider;getBiome(III)Lnet/minecraft/core/Holder;")})
    private Holder<Biome> biolith$getCaveBiome(CaveBiomeProvider instance, int biomeX, int biomeY, int biomeZ, Operation<Holder<Biome>> operation) {
        Holder original = (Holder)operation.call(new Object[]{instance, biomeX, biomeY, biomeZ});
        if (original == null) {
            return null;
        }
        return BiomeCoordinator.OVERWORLD.getReplacementEntry(biomeX, biomeY, biomeZ, (Holder<Biome>)original);
    }

    @WrapOperation(method={"getBiomeForSpawn(III)Lnet/minecraft/core/Holder;", "getBiomeForSurfaceGen(Lnet/minecraft/server/level/WorldGenRegion;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;"}, at={@At(value="INVOKE", target="Lmod/bluestaggo/modernerbeta/api/world/biome/BiomeResolverBlock;getBiomeBlock(III)Lnet/minecraft/core/Holder;")})
    private Holder<Biome> biolith$getBiomeBlock(BiomeResolverBlock instance, int x, int y, int z, Operation<Holder<Biome>> operation) {
        Holder original = (Holder)operation.call(new Object[]{instance, x, y, z});
        int biomeX = x >> 2;
        int biomeY = y >> 2;
        int biomeZ = z >> 2;
        return BiomeCoordinator.OVERWORLD.getReplacementEntry(biomeX, biomeY, biomeZ, (Holder<Biome>)original);
    }

    @ModifyReturnValue(method={"collectPossibleBiomes()Ljava/util/stream/Stream;"}, at={@At(value="RETURN")})
    private Stream<Holder<Biome>> biolith$injectBiomes(Stream<Holder<Biome>> original) {
        Set entrySet = original.collect(Collectors.toSet());
        BiomeCoordinator.OVERWORLD.writeBiomeEntries(entryPair -> entrySet.add((Holder)entryPair.getSecond()));
        return entrySet.stream();
    }
}

