/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.automessage;

import fabric.com.cursee.automessage.Constants;
import fabric.com.cursee.automessage.core.message.ClientMessageService;
import fabric.com.cursee.automessage.core.message.util.MessageType;
import fabric.com.cursee.automessage.core.util.JsonFileHelper;
import fabric.com.cursee.automessage.platform.Services;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;

public class AutoMessageClient {
    private static final String AUTOMESSAGE_DATA_DIR_FILEPATH = Services.PLATFORM.getGameDirectory() + File.separator + "automessage_data";
    private static final String CLIENT_SERVER_TAGS_FILEPATH = Services.PLATFORM.getGameDirectory() + File.separator + "automessage_data" + File.separator + "client_server_tags.json";
    public static class_310 CLIENT;

    public static void init(class_310 client) {
        CLIENT = client;
        ClientMessageService.load();
        File autoMessageDataDirectory = new File(AUTOMESSAGE_DATA_DIR_FILEPATH);
        if (!autoMessageDataDirectory.isDirectory()) {
            autoMessageDataDirectory.mkdirs();
        }
        JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, "World Name", "your_message_identifier.firstJoin");
        JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, "127.0.0.1", "your_message_identifier.firstJoin");
    }

    public static void onFirstJoinLevel(class_746 player, class_638 level) {
        if (level == null || !ClientMessageService.instance.general.enabled) {
            return;
        }
        CLIENT = class_310.method_1551();
        ClientMessageService.instance.ON_FIRST_JOIN_MESSAGES.forEach(message -> {
            String serverName;
            if (CLIENT.method_1496()) {
                MinecraftServer server = (MinecraftServer)Objects.requireNonNull(CLIENT.method_1576());
                serverName = server.method_27050(class_5218.field_24182).toString();
                serverName = serverName.replaceAll("(?s)^.*?(?=" + server.method_27728().method_150() + ")", "").replace(File.separatorChar + "playerdata", "");
            } else {
                serverName = Objects.requireNonNull(AutoMessageClient.CLIENT.method_1558()).field_3761;
            }
            if (message.pack_intro && JsonFileHelper.anyKeyContainsTag(new File(CLIENT_SERVER_TAGS_FILEPATH), message.identifier + ".firstJoin")) {
                return;
            }
            if (JsonFileHelper.hasKey(CLIENT_SERVER_TAGS_FILEPATH, serverName)) {
                Constants.LOG.info("Client had key {}, so tags that were already generated are being checked.", (Object)serverName);
            }
            boolean hasTag = JsonFileHelper.hasTag(CLIENT_SERVER_TAGS_FILEPATH, serverName, message.identifier + ".firstJoin");
            if (message.repeats || !hasTag) {
                if (message.type == MessageType.CHAT) {
                    if (message.link != null && !message.link.isEmpty()) {
                        player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString()).replace("%link%", message.link)).method_27694(style -> {
                            try {
                                URI uri = new URI(message.link);
                                return style.method_10958((class_2558)new class_2558.class_10608(uri));
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                return style;
                            }
                        }), false);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString())), false);
                    }
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString())), true);
                }
                if (!message.repeats && !hasTag) {
                    JsonFileHelper.addTag(CLIENT_SERVER_TAGS_FILEPATH, serverName, message.identifier + ".firstJoin");
                }
            }
        });
    }

    public static void onJoinLevel(class_746 player, class_638 level) {
        if (level == null || !ClientMessageService.instance.general.enabled) {
            return;
        }
        ClientMessageService.instance.ON_JOIN_LEVEL_MESSAGES.forEach(message -> {
            if (message.type == MessageType.CHAT) {
                if (message.link != null && !message.link.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString()).replace("%link%", message.link)).method_27694(style -> {
                        try {
                            URI uri = new URI(message.link);
                            return style.method_10958((class_2558)new class_2558.class_10608(uri));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            return style;
                        }
                    }), false);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString())), false);
                }
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString())), true);
            }
        });
    }

    public static void onDeath(class_1657 player) {
        ClientMessageService.instance.ON_DEATH_MESSAGES.forEach(message -> {
            if (message.type == MessageType.CHAT) {
                if (message.link != null && !message.link.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString()).replace("%link%", message.link)).method_27694(style -> {
                        try {
                            URI uri = new URI(message.link);
                            return style.method_10958((class_2558)new class_2558.class_10608(uri));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            return style;
                        }
                    }), false);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString())), false);
                }
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString())), true);
            }
        });
    }

    public static void onRespawn(class_746 player) {
        ClientMessageService.instance.ON_RESPAWN_MESSAGES.forEach(message -> {
            if (message.type == MessageType.CHAT) {
                if (message.link != null && !message.link.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString()).replace("%link%", message.link)).method_27694(style -> {
                        try {
                            URI uri = new URI(message.link);
                            return style.method_10958((class_2558)new class_2558.class_10608(uri));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            return style;
                        }
                    }), false);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString())), false);
                }
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)message.text.replace("%player%", player.method_5476().getString())), true);
            }
        });
    }
}

