/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.automessage.core.message.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import fabric.com.cursee.automessage.Constants;
import fabric.com.cursee.automessage.core.message.ClientMessageService;
import fabric.com.cursee.automessage.core.message.ServerMessageService;
import fabric.com.cursee.automessage.core.message.util.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_151;

public class MessageServiceUtil {
    public static void copyResourceToFile(String resource, File destination) {
        try (InputStream input = ClientMessageService.class.getResourceAsStream(resource);){
            if (input == null) {
                throw new class_151("Invalid resource path: " + resource);
            }
            destination.getParentFile().mkdirs();
            try (FileOutputStream output = new FileOutputStream(destination);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = input.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                Constants.LOG.info("Copied resource to: {}", (Object)destination.getAbsolutePath());
            }
        }
        catch (IOException e) {
            Constants.LOG.info("Failed to write {} to file: {}", (Object)resource, (Object)destination.getPath());
            Constants.LOG.info(e.toString());
            e.fillInStackTrace();
        }
    }

    public static void loadFallbackMessages(Gson gson) {
        block13: {
            try (InputStream in = ClientMessageService.class.getResourceAsStream("/assets/automessage/default_messages.json");){
                if (in == null) break block13;
                try (InputStreamReader reader = new InputStreamReader(in);){
                    Type listType = new TypeToken<List<Message>>(){}.getType();
                    List fallback = (List)gson.fromJson((Reader)reader, listType);
                    ClientMessageService.instance.ON_FIRST_JOIN_MESSAGES.addAll(fallback);
                    ServerMessageService.instance.ON_FIRST_JOIN_MESSAGES.addAll(fallback);
                    Constants.LOG.info("Loaded fallback messages from mod resources.");
                }
                return;
            }
            catch (Exception e) {
                Constants.LOG.info("Failed to load fallback message resource.");
                Constants.LOG.info(e.toString());
                e.fillInStackTrace();
            }
        }
        Message fallbackMessage = Message.defaultFallback();
        ClientMessageService.instance.ON_FIRST_JOIN_MESSAGES.add(fallbackMessage);
        ServerMessageService.instance.ON_FIRST_JOIN_MESSAGES.add(fallbackMessage);
        Constants.LOG.info("Loaded hard-coded fallback message.");
    }

    public static ArrayList<File> resolveMessagePaths(String pattern) {
        ArrayList<File> results = new ArrayList<File>();
        Path configDir = new File("config").toPath();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        try (Stream<Path> pathStream = Files.walk(configDir, new FileVisitOption[0]);){
            pathStream.filter(path -> matcher.matches(configDir.relativize((Path)path))).forEach(path -> results.add(path.toFile()));
        }
        catch (IOException e) {
            Constants.LOG.info("Failed to resolve glob : {}", (Object)pattern);
            Constants.LOG.info(e.toString());
            e.fillInStackTrace();
        }
        return results;
    }

    public static boolean areAllListsEmpty(List<List<?>> lists) {
        if (lists == null) {
            return true;
        }
        for (List<?> list : lists) {
            if (list == null || list.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

