/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import com.mcwroofs.kikoz.init.BlockInit;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GutterTall
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape[] SHAPES = new VoxelShape[12];
    public static final BooleanProperty ABOVE;
    public static final BooleanProperty BELOW;
    private static final BooleanProperty WATER;

    public GutterTall(BlockState state, BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATER, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)ABOVE, (Comparable)Boolean.valueOf(false))).setValue((Property)BELOW, (Comparable)Boolean.valueOf(false)));
    }

    private BlockState GutterState(BlockState state, LevelReader access, BlockPos pos) {
        boolean above = access.getBlockState(pos.above()).getBlock() == this;
        boolean below = access.getBlockState(pos.below()).getBlock() == this;
        return (BlockState)((BlockState)state.setValue((Property)ABOVE, (Comparable)Boolean.valueOf(above))).setValue((Property)BELOW, (Comparable)Boolean.valueOf(below));
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState statetwo, boolean bolean) {
        if (!statetwo.is(state.getBlock())) {
            this.GutterState(state, (LevelReader)world, pos);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        this.GutterState(state, (LevelReader)world, pos);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return this.GutterState(state, level, currentPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.GutterState(super.getStateForPlacement(context), (LevelReader)context.getLevel(), context.getClickedPos()).setValue(FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    public void placeAt(Level world, BlockPos pos, int into) {
        world.setBlock(pos, this.defaultBlockState(), into);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        Direction facing;
        boolean isBelow;
        boolean isAbove = (Boolean)state.getValue((Property)ABOVE);
        int shapeIndex = this.getShapeIndex(isAbove, isBelow = ((Boolean)state.getValue((Property)BELOW)).booleanValue(), facing = (Direction)state.getValue(FACING));
        if (shapeIndex >= 0 && shapeIndex < SHAPES.length) {
            return SHAPES[shapeIndex];
        }
        return Shapes.empty();
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Boolean i = (Boolean)state.getValue((Property)WATER);
        Item item = itemstack.getItem();
        ItemStack heldItem = player.getItemInHand(hand);
        if (item == Items.WATER_BUCKET && !i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            itemstack.shrink(1);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
        }
        if (item == Items.BUCKET && i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            itemstack.shrink(1);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.WATER_BUCKET));
        }
        if (item == Items.GLASS_BOTTLE && i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.POTION));
        }
        if (item instanceof DyeItem) {
            DyeColor dyeColor = ((DyeItem)item).getDyeColor();
            Block blockToPlace = null;
            switch (dyeColor) {
                case WHITE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_WHITE.get();
                    break;
                }
                case LIGHT_GRAY: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_LIGHT_GRAY.get();
                    break;
                }
                case GRAY: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_GRAY.get();
                    break;
                }
                case BLACK: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_BLACK.get();
                    break;
                }
                case BROWN: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_BROWN.get();
                    break;
                }
                case RED: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_RED.get();
                    break;
                }
                case ORANGE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_ORANGE.get();
                    break;
                }
                case YELLOW: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_YELLOW.get();
                    break;
                }
                case LIME: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_LIME.get();
                    break;
                }
                case GREEN: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_GREEN.get();
                    break;
                }
                case CYAN: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_CYAN.get();
                    break;
                }
                case LIGHT_BLUE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_LIGHT_BLUE.get();
                    break;
                }
                case BLUE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_BLUE.get();
                    break;
                }
                case PURPLE: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_PURPLE.get();
                    break;
                }
                case MAGENTA: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_MAGENTA.get();
                    break;
                }
                case PINK: {
                    blockToPlace = (Block)BlockInit.GUTTER_MIDDLE_PINK.get();
                    break;
                }
                default: {
                    return InteractionResult.PASS;
                }
            }
            Direction currentFacing = (Direction)state.getValue(FACING);
            Boolean currentWater = (Boolean)state.getValue((Property)WATER);
            Boolean currentAbove = (Boolean)state.getValue((Property)ABOVE);
            Boolean currentBelow = (Boolean)state.getValue((Property)BELOW);
            BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)blockToPlace.defaultBlockState().setValue(FACING, (Comparable)currentFacing)).setValue((Property)WATER, (Comparable)currentWater)).setValue((Property)ABOVE, (Comparable)currentAbove)).setValue((Property)BELOW, (Comparable)currentBelow);
            world.setBlockAndUpdate(pos, newState);
            if (!player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private int getShapeIndex(boolean isAbove, boolean isBelow, Direction facing) {
        if (!isAbove && !isBelow) {
            switch (facing) {
                case WEST: {
                    return 2;
                }
                case EAST: {
                    return 0;
                }
                case SOUTH: {
                    return 1;
                }
                case NORTH: {
                    return 3;
                }
            }
        } else if (isAbove && isBelow) {
            switch (facing) {
                case WEST: {
                    return 6;
                }
                case EAST: {
                    return 4;
                }
                case SOUTH: {
                    return 5;
                }
                case NORTH: {
                    return 7;
                }
            }
        } else if (isAbove && !isBelow) {
            switch (facing) {
                case WEST: {
                    return 2;
                }
                case EAST: {
                    return 0;
                }
                case SOUTH: {
                    return 1;
                }
                case NORTH: {
                    return 3;
                }
            }
        } else {
            switch (facing) {
                case WEST: {
                    return 10;
                }
                case EAST: {
                    return 8;
                }
                case SOUTH: {
                    return 9;
                }
                case NORTH: {
                    return 11;
                }
            }
        }
        return -1;
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.levelEvent(1029, pos, 0);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.above(30);
        if (state.hasProperty((Property)WATER)) {
            if (world.isRainingAt(blockpos) && !((Boolean)state.getValue((Property)WATER)).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(true)));
                this.scheduleSpread(world, pos);
            }
            if (!world.isRainingAt(blockpos) && ((Boolean)state.getValue((Property)WATER)).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(false)));
                this.scheduleClear(world, pos);
            }
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.above(30);
        if (world.isRainingAt(blockpos)) {
            if (state.hasProperty((Property)WATER) && !((Boolean)state.getValue((Property)WATER)).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(true)));
                this.scheduleSpread(world, pos);
            }
        } else if (state.hasProperty((Property)WATER) && ((Boolean)state.getValue((Property)WATER)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(false)));
            this.scheduleClear(world, pos);
        }
    }

    private void scheduleSpread(ServerLevel world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        for (BlockPos neighbor : this.getNeighborPositions(pos)) {
            BlockState neighborState = world.getBlockState(neighbor);
            if (neighborState.getBlock() != state.getBlock() || !neighborState.hasProperty((Property)WATER) || ((Boolean)neighborState.getValue((Property)WATER)).booleanValue()) continue;
            world.scheduleTick(neighbor, (Block)this, 6);
        }
    }

    private void scheduleClear(ServerLevel world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        for (BlockPos neighbor : this.getNeighborPositions(pos)) {
            BlockState neighborState = world.getBlockState(neighbor);
            if (neighborState.getBlock() != state.getBlock() || !neighborState.hasProperty((Property)WATER) || !((Boolean)neighborState.getValue((Property)WATER)).booleanValue()) continue;
            world.scheduleTick(neighbor, (Block)this, 6);
        }
    }

    private List<BlockPos> getNeighborPositions(BlockPos pos) {
        return List.of(pos.north(), pos.south(), pos.east(), pos.west());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ABOVE, BELOW, WATER});
    }

    static {
        GutterTall.SHAPES[0] = Shapes.or((VoxelShape)Block.box((double)6.0, (double)5.6, (double)4.0, (double)10.0, (double)9.8, (double)7.4), (VoxelShape)Block.box((double)6.0, (double)5.6, (double)0.0, (double)10.0, (double)16.0, (double)4.0));
        GutterTall.SHAPES[1] = Shapes.or((VoxelShape)Block.box((double)8.8, (double)5.6, (double)6.0, (double)12.1, (double)9.8, (double)10.0), (VoxelShape)Block.box((double)12.1, (double)5.6, (double)6.0, (double)16.1, (double)16.0, (double)10.0));
        GutterTall.SHAPES[2] = Shapes.or((VoxelShape)Block.box((double)6.0, (double)5.6, (double)8.7, (double)10.0, (double)9.8, (double)12.0), (VoxelShape)Block.box((double)6.0, (double)5.6, (double)12.0, (double)10.0, (double)16.0, (double)16.0));
        GutterTall.SHAPES[3] = Shapes.or((VoxelShape)Block.box((double)4.0, (double)5.6, (double)6.0, (double)7.3, (double)9.8, (double)10.0), (VoxelShape)Block.box((double)0.0, (double)5.6, (double)6.0, (double)4.0, (double)16.0, (double)10.0));
        GutterTall.SHAPES[4] = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[5] = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[6] = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[7] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[0]);
        GutterTall.SHAPES[8] = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)5.0), Block.box((double)0.0, (double)11.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0), Block.box((double)6.0, (double)6.0, (double)0.8, (double)10.0, (double)8.975, (double)5.0), Block.box((double)5.0, (double)9.0, (double)0.8, (double)11.0, (double)14.975, (double)7.0)});
        GutterTall.SHAPES[9] = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)12.0, (double)11.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0), Block.box((double)11.0, (double)6.0, (double)6.0, (double)16.0, (double)9.0, (double)10.0), Block.box((double)9.0, (double)9.0, (double)5.0, (double)16.0, (double)15.0, (double)11.0)});
        GutterTall.SHAPES[10] = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)12.0, (double)10.0, (double)6.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)11.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0), Block.box((double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)9.0, (double)16.0), Block.box((double)5.0, (double)9.0, (double)9.0, (double)11.0, (double)15.0, (double)16.0)});
        GutterTall.SHAPES[11] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)6.0, (double)4.0, (double)6.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)0.0, (double)5.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0), Block.box((double)1.0, (double)6.0, (double)6.0, (double)5.0, (double)9.0, (double)10.0), Block.box((double)1.0, (double)9.0, (double)5.0, (double)7.0, (double)15.0, (double)11.0)});
        ABOVE = BooleanProperty.create((String)"above");
        BELOW = BooleanProperty.create((String)"below");
        WATER = BooleanProperty.create((String)"water");
    }
}

