/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration;

import com.mojang.logging.LogUtils;
import edivad.edivadlib.setup.UpdateChecker;
import edivad.solargeneration.blockentity.SolarPanelBlockEntity;
import edivad.solargeneration.client.screen.SolarPanelScreen;
import edivad.solargeneration.datagen.SolarGenerationAdvancementProvider;
import edivad.solargeneration.datagen.SolarGenerationLang;
import edivad.solargeneration.datagen.SolarGenerationLootTableProvider;
import edivad.solargeneration.datagen.SolarGenerationModelProvider;
import edivad.solargeneration.datagen.SolarGenerationRecipes;
import edivad.solargeneration.datagen.SolarPanelBlockTagsProvider;
import edivad.solargeneration.datagen.SolarPanelItemTagsProvider;
import edivad.solargeneration.network.packet.UpdateSolarPanel;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.setup.SolarGenerationCreativeModeTabs;
import edivad.solargeneration.tools.SolarGenerationDataComponents;
import edivad.solargeneration.tools.SolarPanelLevel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.energy.ComponentEnergyStorage;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="solargeneration")
public class SolarGeneration {
    public static final String ID = "solargeneration";
    public static final String MODNAME = "SolarGeneration";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SolarGeneration(IEventBus modEventBus) {
        modEventBus.addListener(this::handleClientSetup);
        modEventBus.addListener(this::handleRegisterMenuScreens);
        modEventBus.addListener(this::handleGatherData);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::registerPayloads);
        Registration.register(modEventBus);
        SolarGenerationCreativeModeTabs.register(modEventBus);
        SolarGenerationDataComponents.register(modEventBus);
    }

    private void handleClientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new UpdateChecker(ID));
    }

    private void handleRegisterMenuScreens(RegisterMenuScreensEvent event) {
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            MenuType menu = (MenuType)Registration.SOLAR_PANEL_MENU.get((Object)level).get();
            event.register(menu, SolarPanelScreen::new);
        }
    }

    private void handleGatherData(GatherDataEvent.Client event) {
        event.createProvider(SolarGenerationLootTableProvider::new);
        event.createBlockAndItemTags(SolarPanelBlockTagsProvider::new, (packOutput, lookupProvider, __) -> new SolarPanelItemTagsProvider(packOutput, lookupProvider));
        event.createProvider(SolarGenerationAdvancementProvider::new);
        event.createProvider(SolarGenerationRecipes.Runner::new);
        event.createProvider(SolarGenerationLang::new);
        event.createProvider(SolarGenerationModelProvider::new);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        Registration.SOLAR_PANEL_BLOCK_ENTITY.forEach((__, blockEntityType) -> event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)blockEntityType.get(), SolarPanelBlockEntity::getSolarPanelBattery));
        Registration.HELMET.forEach((solarPanelLevel, item) -> event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new ComponentEnergyStorage((MutableDataComponentHolder)stack, (DataComponentType)SolarGenerationDataComponents.ENERGY_COMPONENT.get(), solarPanelLevel.getCapacity(), solarPanelLevel.getMaxTransfer()), new ItemLike[]{(ItemLike)item.get()}));
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(ID).versioned("1");
        registrar.playToClient(UpdateSolarPanel.TYPE, UpdateSolarPanel.STREAM_CODEC, UpdateSolarPanel::handle);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }
}

