/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.client.screen;

import edivad.solargeneration.SolarGeneration;
import edivad.solargeneration.blockentity.SolarPanelBlockEntity;
import edivad.solargeneration.menu.SolarPanelMenu;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SolarPanelScreen
extends AbstractContainerScreen<SolarPanelMenu> {
    private static final ResourceLocation TEXTURE = SolarGeneration.rl("textures/gui/solar_panel.png");
    private final SolarPanelBlockEntity solarPanelBlockEntity;

    public SolarPanelScreen(SolarPanelMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.solarPanelBlockEntity = menu.solarPanelBlockEntity;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (mouseX > this.leftPos + 7 && mouseX < this.leftPos + 29 && mouseY > this.topPos + 10 && mouseY < this.topPos + 77) {
            MutableComponent component = Component.translatable((String)"gui.solargeneration.energy", (Object[])new Object[]{this.getPercent()});
            ClientTooltipComponent clienttooltipcomponent = ClientTooltipComponent.create((FormattedCharSequence)component.getVisualOrderText());
            guiGraphics.renderTooltip(this.font, List.of(clienttooltipcomponent), mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MutableComponent energy = Component.translatable((String)"gui.solargeneration.stored_energy", (Object[])new Object[]{this.getEnergyFormatted(this.solarPanelBlockEntity.energyClient)});
        guiGraphics.drawString(this.font, (Component)energy, this.imageWidth / 2 - this.font.width((FormattedText)energy) / 2 + 14, 20, -13421773, false);
        MutableComponent maxEnergy = Component.translatable((String)"gui.solargeneration.capacity", (Object[])new Object[]{this.getEnergyFormatted(this.solarPanelBlockEntity.getLevelSolarPanel().getCapacity())});
        guiGraphics.drawString(this.font, (Component)maxEnergy, this.imageWidth / 2 - this.font.width((FormattedText)maxEnergy) / 2 + 14, 30, -13421773, false);
        MutableComponent generation = Component.translatable((String)"gui.solargeneration.generation", (Object[])new Object[]{this.solarPanelBlockEntity.energyProductionClient});
        guiGraphics.drawString(this.font, (Component)generation, this.imageWidth / 2 - this.font.width((FormattedText)generation) / 2 + 14, 40, -13421773, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int y = this.getEnergyScaled(60);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos + 10, this.topPos + 12 + y, (float)this.imageWidth, 0.0f, 16, 60 - y, 256, 256);
    }

    private String getEnergyFormatted(int energy) {
        if (energy >= 1000000) {
            return energy / 1000 + " kFE";
        }
        return energy + " FE";
    }

    private int getEnergyScaled(int pixels) {
        return pixels - pixels * this.getPercent() / 100;
    }

    private int getPercent() {
        long currentEnergy = this.solarPanelBlockEntity.energyClient;
        int maxEnergy = this.solarPanelBlockEntity.getLevelSolarPanel().getCapacity();
        long result = currentEnergy * 100L / (long)maxEnergy;
        return (int)result;
    }
}

