/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.datagen;

import edivad.edivadlib.tools.TranslationsAdvancement;
import edivad.solargeneration.SolarGeneration;
import edivad.solargeneration.items.SolarPanelBlockItem;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Translations;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;

public class SolarGenerationAdvancementProvider
extends AdvancementProvider {
    public SolarGenerationAdvancementProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries, List.of(new Advancements()));
    }

    private static class Advancements
    implements AdvancementSubProvider {
        private Advancements() {
        }

        private static AdvancementType getFrameType(SolarPanelLevel level) {
            return switch (level) {
                default -> throw new MatchException(null, null);
                case SolarPanelLevel.LEADSTONE, SolarPanelLevel.HARDENED, SolarPanelLevel.REDSTONE -> AdvancementType.TASK;
                case SolarPanelLevel.SIGNALUM, SolarPanelLevel.RESONANT -> AdvancementType.GOAL;
                case SolarPanelLevel.ADVANCED, SolarPanelLevel.ULTIMATE -> AdvancementType.CHALLENGE;
            };
        }

        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> writer) {
            TranslationsAdvancement translations;
            DeferredItem<SolarPanelBlockItem> item;
            AdvancementHolder ROOT;
            AdvancementHolder parent = ROOT = Advancement.Builder.advancement().display((ItemLike)Registration.PHOTOVOLTAIC_CELL.get(), (Component)Translations.ADVANCEMENTS_ROOT.translateTitle(), (Component)Translations.ADVANCEMENTS_ROOT.translateDescription(), SolarGeneration.rl("textures/gui/advancements.png"), AdvancementType.TASK, true, true, false).addCriterion("inv_changed", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)Registration.PHOTOVOLTAIC_CELL.get()})).save(writer, SolarGeneration.rl("root"));
            for (SolarPanelLevel level : SolarPanelLevel.values()) {
                item = Registration.SOLAR_PANEL_ITEM.get((Object)level);
                translations = Translations.SOLAR_PANEL_ADVANCEMENTS.get((Object)level);
                parent = this.generateAdvancements(writer, level, parent, (Item)item.get(), translations, level.getSolarPanelName());
            }
            parent = ROOT;
            for (SolarPanelLevel level : SolarPanelLevel.values()) {
                item = Registration.HELMET.get((Object)level);
                translations = Translations.HELMET_ADVANCEMENTS.get((Object)level);
                parent = this.generateAdvancements(writer, level, parent, (Item)item.get(), translations, level.getSolarHelmetName());
            }
        }

        private AdvancementHolder generateAdvancements(Consumer<AdvancementHolder> writer, SolarPanelLevel level, AdvancementHolder parent, Item item, TranslationsAdvancement itemTranslations, String name) {
            return Advancement.Builder.advancement().display((ItemLike)item, (Component)itemTranslations.translateTitle(), (Component)itemTranslations.translateDescription(), null, Advancements.getFrameType(level), true, true, false).addCriterion("inv_changed", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item})).parent(parent).save(writer, SolarGeneration.rl(name));
        }
    }
}

