/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.datagen;

import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Translations;
import java.util.HashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.apache.commons.lang3.tuple.Pair;

public class SolarGenerationLang
extends LanguageProvider {
    public SolarGenerationLang(PackOutput packOutput) {
        super(packOutput, "solargeneration", "en_us");
    }

    protected void addTranslations() {
        HashMap<SolarPanelLevel, String> translations = new HashMap<SolarPanelLevel, String>();
        translations.put(SolarPanelLevel.LEADSTONE, "Leadstone");
        translations.put(SolarPanelLevel.HARDENED, "Hardened");
        translations.put(SolarPanelLevel.REDSTONE, "Redstone");
        translations.put(SolarPanelLevel.SIGNALUM, "Signalum");
        translations.put(SolarPanelLevel.RESONANT, "Resonant");
        translations.put(SolarPanelLevel.ADVANCED, "Advanced");
        translations.put(SolarPanelLevel.ULTIMATE, "Ultimate");
        Registration.CORE.forEach((level, item) -> this.add((Item)item.get(), String.format("%s Solar Core", translations.get(level))));
        Registration.HELMET.forEach((level, item) -> this.add((Item)item.get(), String.format("%s Solar Helmet", translations.get(level))));
        Registration.SOLAR_PANEL_ITEM.forEach((level, item) -> this.add((Item)item.get(), String.format("%s Solar Panel", translations.get(level))));
        this.add((Item)Registration.LAPIS_SHARD.get(), "Lapis Shard");
        this.add((Item)Registration.PHOTOVOLTAIC_CELL.get(), "Photovoltaic Cell");
        this.add("gui.solargeneration.stored_energy", "Stored energy: %s");
        this.add("gui.solargeneration.capacity", "Capacity: %s");
        this.add("gui.solargeneration.generation", "Generation: %s FE/t");
        this.add("gui.solargeneration.energy", "Energy: %s%%");
        this.add("message.solargeneration.transfer", "Transfer: %s FE/t");
        this.add("message.solargeneration.for_details", "for details");
        this.add("message.solargeneration.for_stored_energy", "for stored energy");
        this.add("message.solargeneration.hold", "Hold");
        this.generateAdvancements();
    }

    private void generateAdvancements() {
        this.add(Translations.ADVANCEMENTS_ROOT.title(), "SolarGeneration");
        this.add(Translations.ADVANCEMENTS_ROOT.desc(), "Start your solar-power journey by creating a Photovoltaic Cell.");
        HashMap<SolarPanelLevel, Pair> advancementsSolarPanel = new HashMap<SolarPanelLevel, Pair>();
        advancementsSolarPanel.put(SolarPanelLevel.LEADSTONE, Pair.of((Object)"Start with the basics", (Object)"Craft a Leadstone Solar Panel."));
        advancementsSolarPanel.put(SolarPanelLevel.HARDENED, Pair.of((Object)"1 is better than 8", (Object)"Craft a Hardened Solar Panel."));
        advancementsSolarPanel.put(SolarPanelLevel.REDSTONE, Pair.of((Object)"Not enough energy", (Object)"Craft a Redstone Solar Panel."));
        advancementsSolarPanel.put(SolarPanelLevel.SIGNALUM, Pair.of((Object)"Looking for the signal", (Object)"Craft a Signalum Solar Panel."));
        advancementsSolarPanel.put(SolarPanelLevel.RESONANT, Pair.of((Object)"Escalation of power", (Object)"Craft a Resonant Solar Panel."));
        advancementsSolarPanel.put(SolarPanelLevel.ADVANCED, Pair.of((Object)"President of energy", (Object)"Craft a Advanced Solar Panel."));
        advancementsSolarPanel.put(SolarPanelLevel.ULTIMATE, Pair.of((Object)"Oh sun, I control you!", (Object)"Craft a Ultimate Solar Panel."));
        advancementsSolarPanel.forEach((level, pair) -> {
            this.add(Translations.SOLAR_PANEL_ADVANCEMENTS.get(level).title(), (String)pair.getLeft());
            this.add(Translations.SOLAR_PANEL_ADVANCEMENTS.get(level).desc(), (String)pair.getRight());
        });
        HashMap<SolarPanelLevel, Pair> advancementsSolarHelmet = new HashMap<SolarPanelLevel, Pair>();
        advancementsSolarHelmet.put(SolarPanelLevel.LEADSTONE, Pair.of((Object)"Using your head!", (Object)"Craft a Leadstone Solar Helmet."));
        advancementsSolarHelmet.put(SolarPanelLevel.HARDENED, Pair.of((Object)"8 helmets in 1", (Object)"Craft a Hardened Solar Helmet."));
        advancementsSolarHelmet.put(SolarPanelLevel.REDSTONE, Pair.of((Object)"Electric mind", (Object)"Craft a Redstone Solar Helmet."));
        advancementsSolarHelmet.put(SolarPanelLevel.SIGNALUM, Pair.of((Object)"Brain signals", (Object)"Craft a Signalum Solar Helmet."));
        advancementsSolarHelmet.put(SolarPanelLevel.RESONANT, Pair.of((Object)"Resonating tune", (Object)"Craft a Resonant Solar Helmet."));
        advancementsSolarHelmet.put(SolarPanelLevel.ADVANCED, Pair.of((Object)"Fancy crown", (Object)"Craft a Advanced Solar Helmet."));
        advancementsSolarHelmet.put(SolarPanelLevel.ULTIMATE, Pair.of((Object)"The Ultimate Helmet", (Object)"Craft a Ultimate Solar Helmet."));
        advancementsSolarHelmet.forEach((level, pair) -> {
            this.add(Translations.HELMET_ADVANCEMENTS.get(level).title(), (String)pair.getLeft());
            this.add(Translations.HELMET_ADVANCEMENTS.get(level).desc(), (String)pair.getRight());
        });
    }
}

