/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.datagen;

import edivad.solargeneration.SolarGeneration;
import edivad.solargeneration.blocks.SolarPanelBlock;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class SolarGenerationRecipes
extends RecipeProvider {
    private final HolderLookup.RegistryLookup<Item> items;

    protected SolarGenerationRecipes(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
        this.items = registries.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        this.supportingItems();
        this.solarPanelReverse();
        this.solarHelmet();
        this.solarPanel();
        this.solarCore();
    }

    private void supportingItems() {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LAPIS_LAZULI).pattern("aaa").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Registration.LAPIS_SHARD.get()).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)((ItemLike)Registration.LAPIS_SHARD.get())), this.has((ItemLike)Registration.LAPIS_SHARD.get())).save(this.output, SolarGeneration.rl("lapis_lazuli_from_shard").toString());
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.LAPIS_SHARD.get()), (int)36).pattern("aa").pattern("aa").define(Character.valueOf('a'), (ItemLike)Items.LAPIS_LAZULI).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)Items.LAPIS_LAZULI), this.has((ItemLike)Items.LAPIS_LAZULI)).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.PHOTOVOLTAIC_CELL.get())).pattern("aaa").pattern("bbb").pattern("ccc").define(Character.valueOf('a'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('b'), (ItemLike)Registration.LAPIS_SHARD.get()).define(Character.valueOf('c'), Tags.Items.NUGGETS_IRON).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)((ItemLike)Registration.LAPIS_SHARD.get())), this.has((ItemLike)Registration.LAPIS_SHARD.get())).save(this.output);
    }

    private void solarPanelReverse() {
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            SolarPanelBlock solarPanel = (SolarPanelBlock)((Object)Registration.SOLAR_PANEL_BLOCK.get((Object)level).get());
            Item helmet = (Item)Registration.HELMET.get((Object)level).get();
            ResourceLocation resourceLocation = SolarGeneration.rl(level.getSolarPanelName() + "_reverse");
            ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)solarPanel).requires((ItemLike)helmet).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)helmet), this.has((ItemLike)helmet)).save(this.output, resourceLocation.toString());
        }
    }

    private void solarHelmet() {
        for (SolarPanelLevel level : SolarPanelLevel.values()) {
            SolarPanelBlock solarPanel = (SolarPanelBlock)((Object)Registration.SOLAR_PANEL_BLOCK.get((Object)level).get());
            Item helmet = (Item)Registration.HELMET.get((Object)level).get();
            ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)helmet).requires((ItemLike)solarPanel).requires((ItemLike)this.getVanillaHelmet(level)).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)solarPanel), this.has((ItemLike)solarPanel)).save(this.output);
        }
    }

    private void solarPanel() {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.SOLAR_PANEL_BLOCK.get((Object)SolarPanelLevel.LEADSTONE).get())).pattern("aaa").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), (ItemLike)Registration.PHOTOVOLTAIC_CELL.get()).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE).define(Character.valueOf('c'), (ItemLike)Registration.CORE.get((Object)SolarPanelLevel.LEADSTONE).get()).define(Character.valueOf('d'), ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/steel"))).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)((ItemLike)Registration.CORE.get((Object)SolarPanelLevel.LEADSTONE).get())), this.has((ItemLike)Registration.CORE.get((Object)SolarPanelLevel.LEADSTONE).get())).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)((ItemLike)Registration.PHOTOVOLTAIC_CELL.get())), this.has((ItemLike)Registration.PHOTOVOLTAIC_CELL.get())).save(this.output);
        for (int i = 1; i < SolarPanelLevel.values().length; ++i) {
            SolarPanelLevel level = SolarPanelLevel.values()[i];
            SolarPanelBlock currentSolarPanel = (SolarPanelBlock)((Object)Registration.SOLAR_PANEL_BLOCK.get((Object)level).get());
            SolarPanelBlock prevSolarPanel = (SolarPanelBlock)((Object)Registration.SOLAR_PANEL_BLOCK.get((Object)SolarPanelLevel.values()[i - 1]).get());
            Item core = (Item)Registration.CORE.get((Object)level).get();
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)currentSolarPanel).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)prevSolarPanel).define(Character.valueOf('b'), (ItemLike)core).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)prevSolarPanel), this.has((ItemLike)prevSolarPanel)).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)core), this.has((ItemLike)core)).save(this.output);
        }
    }

    private void solarCore() {
        HashMap<SolarPanelLevel, ResourceLocation> materials = new HashMap<SolarPanelLevel, ResourceLocation>();
        materials.put(SolarPanelLevel.HARDENED, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/invar"));
        materials.put(SolarPanelLevel.REDSTONE, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/electrum"));
        materials.put(SolarPanelLevel.SIGNALUM, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/signalum"));
        materials.put(SolarPanelLevel.RESONANT, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/enderium"));
        materials.put(SolarPanelLevel.ADVANCED, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/lumium"));
        materials.put(SolarPanelLevel.ULTIMATE, ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/platinum"));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.CORE.get((Object)SolarPanelLevel.LEADSTONE).get())).pattern(" a ").pattern("aba").pattern(" a ").define(Character.valueOf('a'), ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/lead"))).define(Character.valueOf('b'), ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/iron"))).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)Items.IRON_INGOT), this.has((ItemLike)Items.IRON_INGOT)).save(this.output);
        for (int i = 1; i < SolarPanelLevel.values().length; ++i) {
            SolarPanelLevel level = SolarPanelLevel.values()[i];
            Item core = (Item)Registration.CORE.get((Object)level).get();
            Item prevCore = (Item)Registration.CORE.get((Object)SolarPanelLevel.values()[i - 1]).get();
            ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)core).pattern(" a ").pattern("aba").pattern(" a ").define(Character.valueOf('a'), ItemTags.create((ResourceLocation)((ResourceLocation)materials.get((Object)level)))).define(Character.valueOf('b'), (ItemLike)prevCore).unlockedBy(SolarGenerationRecipes.getHasName((ItemLike)prevCore), this.has((ItemLike)prevCore)).save(this.output);
        }
    }

    private Item getVanillaHelmet(SolarPanelLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case SolarPanelLevel.LEADSTONE, SolarPanelLevel.HARDENED -> Items.IRON_HELMET;
            case SolarPanelLevel.REDSTONE, SolarPanelLevel.SIGNALUM, SolarPanelLevel.RESONANT, SolarPanelLevel.ADVANCED -> Items.DIAMOND_HELMET;
            case SolarPanelLevel.ULTIMATE -> Items.NETHERITE_HELMET;
        };
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new SolarGenerationRecipes(registries, output);
        }

        public String getName() {
            return "SolarGenerationRecipeProvider";
        }
    }
}

