/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.items;

import edivad.solargeneration.SolarGeneration;
import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarGenerationDataComponents;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import java.util.function.Consumer;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class SolarHelmet
extends Item {
    private final SolarPanelLevel solarPanelLevel;
    private final int energyGeneration;
    private final int maxTransfer;

    public SolarHelmet(SolarPanelLevel solarPanelLevel, Item.Properties properties) {
        super(properties.component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.HEAD).setEquipSound(null).setAllowedEntities((HolderSet)HolderSet.direct(EntityType::builtInRegistryHolder, (Object[])new EntityType[]{EntityType.PLAYER})).setDispensable(true).setSwappable(false).setDamageOnHurt(false).setAsset(ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)SolarGeneration.rl(solarPanelLevel.getSolarHelmetName()))).build()));
        this.solarPanelLevel = solarPanelLevel;
        this.energyGeneration = solarPanelLevel.getEnergyGeneration();
        this.maxTransfer = solarPanelLevel.getMaxTransfer();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        int energy = (Integer)stack.getOrDefault(SolarGenerationDataComponents.ENERGY_COMPONENT, (Object)0);
        if (energy > 0) {
            tooltipAdder.accept((Component)Tooltip.showInfoCtrl(energy));
        }
        Tooltip.showInfoShift(this.solarPanelLevel, tooltipAdder);
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.solarPanelLevel;
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return true;
    }

    public int getBarWidth(ItemStack itemStack) {
        IEnergyStorage energy = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return 0;
        }
        if (energy.getEnergyStored() == 0) {
            return 0;
        }
        double charge = (double)energy.getEnergyStored() / (double)energy.getMaxEnergyStored();
        return (int)Math.min(1.0 + 12.0 * charge, 13.0);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (slot != EquipmentSlot.HEAD) {
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return;
        }
        if (energy.getEnergyStored() != energy.getMaxEnergyStored()) {
            energy.receiveEnergy(this.currentAmountEnergyProduced((Level)level, player), false);
        }
        this.sendEnergy(energy, player);
    }

    private void sendEnergy(IEnergyStorage energy, Player player) {
        int i;
        Inventory inventory = player.getInventory();
        for (i = 36; i < 40 && energy.getEnergyStored() > 0; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.getItem() == this) continue;
            this.chargeItem(energy, item);
        }
        for (i = 0; i < 36 && energy.getEnergyStored() > 0; ++i) {
            this.chargeItem(energy, inventory.getItem(i));
        }
    }

    private void chargeItem(IEnergyStorage energyStorage, ItemStack receiver) {
        if (receiver.getCount() != 1) {
            return;
        }
        IEnergyStorage handler = (IEnergyStorage)receiver.getCapability(Capabilities.EnergyStorage.ITEM);
        if (handler == null) {
            return;
        }
        if (handler.canReceive()) {
            while (handler.getEnergyStored() < handler.getMaxEnergyStored() && energyStorage.getEnergyStored() > 0) {
                int accepted = Math.min(this.maxTransfer, handler.receiveEnergy(energyStorage.getEnergyStored(), true));
                energyStorage.extractEnergy(accepted, false);
                handler.receiveEnergy(accepted, false);
            }
        }
    }

    private int currentAmountEnergyProduced(Level level, Player player) {
        return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(level, player.blockPosition().offset(0, 1, 0), this.getLevelSolarPanel()));
    }
}

