/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.tools;

import edivad.solargeneration.tools.SolarPanelLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class ProductionSolarPanel {
    public static float computeSunIntensity(Level level, BlockPos pos, SolarPanelLevel solarPanelLevel) {
        float sunIntensity = 0.0f;
        if (level.canSeeSkyFromBelowWater(pos)) {
            float multiplicator = 1.5f;
            float displacement = 1.2f;
            float celestialAngleRadians = level.getSunAngle(1.0f);
            if ((double)celestialAngleRadians > Math.PI) {
                celestialAngleRadians = 6.283184f - celestialAngleRadians;
            }
            sunIntensity = multiplicator * Mth.cos((float)(celestialAngleRadians / displacement));
            sunIntensity = Math.max(0.0f, sunIntensity);
            if ((sunIntensity = Math.min(1.0f, sunIntensity)) > 0.0f) {
                if (solarPanelLevel == SolarPanelLevel.LEADSTONE) {
                    sunIntensity = 1.0f;
                }
                if (level.isRaining()) {
                    sunIntensity = (float)((double)sunIntensity * 0.4);
                }
                if (level.isThundering()) {
                    sunIntensity = (float)((double)sunIntensity * 0.2);
                }
            }
        }
        return sunIntensity;
    }
}

