/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.tools;

import java.util.Locale;

public enum SolarPanelLevel {
    LEADSTONE,
    HARDENED,
    REDSTONE,
    SIGNALUM,
    RESONANT,
    ADVANCED,
    ULTIMATE;


    public String getSolarPanelName() {
        return "solar_panel_" + this.getCorrectName();
    }

    public String getSolarHelmetName() {
        return "solar_helmet_" + this.getCorrectName();
    }

    public String getSolarCoreName() {
        return "solar_core_" + this.getCorrectName();
    }

    public int getEnergyGeneration() {
        return (int)Math.pow(8.0, this.ordinal());
    }

    public int getMaxTransfer() {
        return this.getEnergyGeneration() * 2;
    }

    public int getCapacity() {
        return this.getEnergyGeneration() * 1000;
    }

    private String getCorrectName() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

