/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.tools;

import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class Tooltip {
    public static void showInfoShift(SolarPanelLevel solarPanelLevel, Consumer<Component> tooltipAdder) {
        ArrayList components = new ArrayList();
        if (Screen.hasShiftDown()) {
            String generation = String.valueOf(solarPanelLevel.getEnergyGeneration());
            String transfer = String.valueOf(solarPanelLevel.getMaxTransfer());
            String capacity = String.valueOf(solarPanelLevel.getCapacity());
            tooltipAdder.accept((Component)Tooltip.buildLineEnergy("gui.solargeneration.generation", generation));
            tooltipAdder.accept((Component)Tooltip.buildLineEnergy("message.solargeneration.transfer", transfer));
            tooltipAdder.accept((Component)Tooltip.buildLineEnergy("gui.solargeneration.capacity", capacity).append(" FE"));
        } else {
            tooltipAdder.accept((Component)Tooltip.buildLineHoldKey("Shift", "message.solargeneration.for_details"));
        }
    }

    public static MutableComponent showInfoCtrl(int energy) {
        if (Screen.hasControlDown()) {
            return Tooltip.buildLineEnergy("gui.solargeneration.stored_energy", String.valueOf(energy)).append(" FE");
        }
        return Tooltip.buildLineHoldKey(Minecraft.ON_OSX ? "Cmd" : "Ctrl", "message.solargeneration.for_stored_energy");
    }

    private static MutableComponent buildLineEnergy(String translationKey, String value) {
        return Component.translatable((String)translationKey, (Object[])new Object[]{value}).withStyle(ChatFormatting.GRAY);
    }

    private static MutableComponent buildLineHoldKey(String key, String reasonKey) {
        return Component.translatable((String)"message.solargeneration.hold").withStyle(ChatFormatting.GRAY).append(" ").append((Component)Component.literal((String)key).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC})).append(" ").append((Component)Component.translatable((String)reasonKey).withStyle(ChatFormatting.GRAY));
    }
}

