/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.capability.ingredient;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandlerClient;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerItemStackClient;
import org.cyclops.integratedterminals.capability.ingredient.sorter.ItemStackIdSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.ItemStackNameSorter;
import org.cyclops.integratedterminals.capability.ingredient.sorter.ItemStackQuantitySorter;

public class IngredientComponentTerminalStorageHandlerItemStack
implements IIngredientComponentTerminalStorageHandler<ItemStack, Integer> {
    private final IngredientComponent<ItemStack, Integer> ingredientComponent;

    public IngredientComponentTerminalStorageHandlerItemStack(IngredientComponent<ItemStack, Integer> ingredientComponent) {
        this.ingredientComponent = ingredientComponent;
    }

    @Override
    public IIngredientComponentTerminalStorageHandlerClient<ItemStack, Integer> getClient() {
        return new IngredientComponentTerminalStorageHandlerItemStackClient(this);
    }

    @Override
    public IngredientComponent<ItemStack, Integer> getComponent() {
        return this.ingredientComponent;
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)Blocks.CHEST);
    }

    @Override
    public String formatQuantity(ItemStack instance) {
        return String.format(Locale.ROOT, "%,d", instance.getCount());
    }

    @Override
    public boolean isInstance(ItemStack itemStack) {
        return itemStack != null;
    }

    @Override
    public ItemStack getInstance(ItemStack itemStack) {
        return itemStack;
    }

    @Override
    public long getMaxQuantity(ItemStack itemStack) {
        return itemStack.getMaxStackSize();
    }

    @Override
    public int getInitialInstanceMovementQuantity() {
        return GeneralConfig.guiStorageItemInitialQuantity;
    }

    @Override
    public int getIncrementalInstanceMovementQuantity() {
        return GeneralConfig.guiStorageItemIncrementalQuantity;
    }

    @Override
    public int throwIntoWorld(IIngredientComponentStorage<ItemStack, Integer> storage, ItemStack maxInstance, Player player) {
        ItemStack extracted = (ItemStack)storage.extract((Object)maxInstance, (Object)13, false);
        if (!extracted.isEmpty()) {
            player.drop(extracted, true);
        }
        return extracted.getCount();
    }

    @Override
    public ItemStack insertIntoContainer(IIngredientComponentStorage<ItemStack, Integer> storage, AbstractContainerMenu container, int containerSlotIndex, ItemStack maxInstance, @Nullable Player player, boolean transferFullSelection) {
        int newCount;
        int inserted;
        ItemStack playerStack;
        ItemStack extracted;
        long movedTotal;
        ItemStack moved;
        ItemStack containerStack;
        IIngredientMatcher matcher = IngredientComponent.ITEMSTACK.getMatcher();
        if (maxInstance.getCount() > 64) {
            maxInstance.setCount(64);
        }
        Slot containerSlot = container.getSlot(containerSlotIndex);
        if (transferFullSelection && player != null && container.getCarried().isEmpty() && !(containerStack = containerSlot.getItem()).isEmpty() && !matcher.matches((Object)containerStack, (Object)maxInstance, (Object)((Integer)matcher.getExactMatchNoQuantityCondition())) && containerSlot.mayPickup(player)) {
            container.setCarried(containerStack);
            containerSlot.onTake(player, containerStack);
            containerSlot.set(ItemStack.EMPTY);
        }
        long requiredQuantity = matcher.getQuantity((Object)maxInstance);
        for (movedTotal = 0L; movedTotal < requiredQuantity && !(extracted = (ItemStack)storage.extract((Object)maxInstance, (Object)((Integer)matcher.getExactMatchNoQuantityCondition()), true)).isEmpty() && ((playerStack = containerSlot.getItem()).isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)extracted, (ItemStack)playerStack)) && containerSlot.mayPlace(extracted) && !(moved = (ItemStack)storage.extract((Object)((ItemStack)matcher.withQuantity((Object)maxInstance, (long)(inserted = (newCount = Math.min(playerStack.getCount() + extracted.getCount(), extracted.getMaxStackSize())) - playerStack.getCount()))), (Object)((Integer)matcher.getExactMatchNoQuantityCondition()), false)).isEmpty(); movedTotal += (long)moved.getCount()) {
            containerSlot.set(((ItemStack)matcher.withQuantity((Object)maxInstance, (long)(containerSlot.getItem().getCount() + moved.getCount()))).copy());
            container.broadcastChanges();
        }
        return (ItemStack)matcher.withQuantity((Object)maxInstance, movedTotal);
    }

    @Override
    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<ItemStack, Integer> storage, AbstractContainerMenu container, Inventory playerInventory, long moveQuantityPlayerSlot) {
        ItemStack playerStack = (ItemStack)IngredientComponent.ITEMSTACK.getMatcher().withQuantity((Object)container.getCarried(), moveQuantityPlayerSlot);
        int remaining = ((ItemStack)storage.insert((Object)playerStack.copy(), false)).getCount();
        int moved = (int)(moveQuantityPlayerSlot - (long)remaining);
        container.getCarried().shrink(moved);
    }

    @Override
    public void extractMaxFromContainerSlot(IIngredientComponentStorage<ItemStack, Integer> storage, AbstractContainerMenu container, int containerSlot, Inventory playerInventory, int limit) {
        ItemStack toMove;
        Slot slot = container.getSlot(containerSlot);
        if (slot.mayPickup(playerInventory.player) && !(toMove = slot.remove(limit == -1 ? Integer.MAX_VALUE : limit)).isEmpty()) {
            ItemStack remainingStack = (ItemStack)storage.insert((Object)toMove, false);
            if (!remainingStack.isEmpty()) {
                if (!slot.hasItem()) {
                    slot.set(remainingStack);
                } else {
                    playerInventory.add(remainingStack);
                }
            }
            container.broadcastChanges();
        }
    }

    @Override
    public long getActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container) {
        return container.getCarried().getCount();
    }

    @Override
    public void drainActivePlayerStackQuantity(Inventory playerInventory, AbstractContainerMenu container, long quantity) {
        container.getCarried().shrink((int)quantity);
    }

    @Override
    public Collection<IIngredientInstanceSorter<ItemStack>> getInstanceSorters() {
        return Lists.newArrayList((Object[])new IIngredientInstanceSorter[]{new ItemStackNameSorter(), new ItemStackIdSorter(), new ItemStackQuantitySorter()});
    }
}

