/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container.component;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.GuiGraphicsExtended;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integratedterminals.Capabilities;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;

public class GuiCraftingPlan
extends AbstractWidget {
    public static final int ELEMENT_WIDTH = 221;
    private static final int ELEMENT_HEIGHT = 16;
    private static final int ELEMENT_HEIGHT_TOTAL = 18;
    private static final int ELEMENT_HEIGHT_MAX = 178;
    protected static final int TICK_DELAY = 30;
    private final AbstractContainerScreen parentGui;
    private final int guiLeft;
    private final int guiTop;
    private final List<Element> elements;
    private final List<Element> visibleElements;
    private final boolean valid;
    private final WidgetScrollBar scrollBar;
    private final String label;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;
    private int firstRow;

    public GuiCraftingPlan(AbstractContainerScreen parentGui, ITerminalCraftingPlan<?> craftingPlan, int guiLeft, int guiTop, int x, int y, int visibleRows) {
        super(x, y, 221, 178, (Component)Component.literal((String)""));
        this.parentGui = parentGui;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.elements = GuiCraftingPlan.getElements(craftingPlan);
        this.visibleElements = Lists.newArrayList(this.elements);
        this.valid = craftingPlan.getStatus().isValid();
        this.scrollBar = new WidgetScrollBar(guiLeft + x + 227, guiTop + y + 0, 178, (Component)Component.translatable((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, visibleRows);
        this.scrollBar.setTotalRows(this.visibleElements.size());
        this.label = IModHelpers.get().getL10NHelpers().localize(craftingPlan.getUnlocalizedLabel(), new Object[0]);
        this.tickDuration = craftingPlan.getTickDuration();
        this.channel = craftingPlan.getChannel();
        this.initiatorName = craftingPlan.getInitiatorName();
    }

    public void inheritVisualizationState(GuiCraftingPlan guiCraftingPlan) {
        float lastScroll = guiCraftingPlan.scrollBar.getCurrentScroll();
        this.scrollBar.scrollTo(lastScroll);
        IntOpenHashSet disabledElementIds = new IntOpenHashSet();
        for (Element element : guiCraftingPlan.elements) {
            if (element.isEnabled()) continue;
            disabledElementIds.add(element.getId());
        }
        for (Element element : this.elements) {
            if (!disabledElementIds.contains(element.getId())) continue;
            element.setEnabled(false);
        }
        this.refreshList();
    }

    protected void refreshList() {
        this.visibleElements.clear();
        GuiCraftingPlan.addActiveElements(this.elements.get(0), this.visibleElements);
        this.scrollBar.setTotalRows(this.visibleElements.size());
    }

    protected static void addActiveElements(Element root, List<Element> elements) {
        if (root.isEnabled()) {
            elements.add(root);
            for (Element child : root.getChildren()) {
                GuiCraftingPlan.addActiveElements(child, elements);
            }
        }
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = Math.max(0, firstRow);
    }

    public void renderWidget(GuiGraphics guiGraphics, int p_268034_, int p_268009_, float p_268085_) {
    }

    protected List<Element> getVisibleElements() {
        return this.visibleElements.subList(this.firstRow, Math.min(this.visibleElements.size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    protected int getAbsoluteElementIndent(Element element) {
        return element.getIndent() * 8;
    }

    public void drawGuiContainerLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int offsetY = 0;
        for (Element element : this.getVisibleElements()) {
            this.drawElement(guiGraphics, element, this.getAbsoluteElementIndent(element), guiLeft + this.getX(), guiTop + this.getY() + offsetY, 221, 16, layer, partialTick, mouseX, mouseY);
            offsetY += 18;
        }
    }

    protected int getTick() {
        return (int)Minecraft.getInstance().level.getGameTime() / 30;
    }

    private void drawElement(GuiGraphics guiGraphics, Element element, int indent, int x, int y, int width, int height, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            guiGraphics.fill(x, y, x + width, y + height + 1, element.getColor());
        }
        int xOriginal = x;
        x += indent;
        if (!element.getChildren().isEmpty() && layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            Image image = element.getChildren().get(0).isEnabled() ? Images.ARROW_DOWN : Images.ARROW_RIGHT;
            image.draw(guiGraphics, x, y);
        }
        x += 16;
        int tick = this.getTick();
        for (List<IPrototypedIngredient<?, ?>> alternatives : element.getOutputs()) {
            IPrototypedIngredient<?, ?> output = alternatives.get(tick % alternatives.size());
            IngredientComponent ingredientComponent = output.getComponent();
            long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
            int finalX = x;
            int finalY = y;
            ingredientComponent.getCapability(Capabilities.IngredientComponentTerminalStorageHandler.INGREDIENT).ifPresent(h -> h.getClient().drawInstance(guiGraphics, output.getPrototype(), quantity, IModHelpers.get().getGuiHelpers().quantityToScaledString(quantity), this.parentGui, layer, partialTick, finalX, finalY, mouseX, mouseY, null));
            x += IModHelpers.get().getGuiHelpers().getSlotSizeInner();
        }
        x = xOriginal + width - 50;
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            int moved = 0;
            if (element.getStorageQuantity() > 0L) {
                GuiCraftingPlan.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.CHEST), x, y, 0.45f);
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, Minecraft.getInstance().font, IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.stored", new Object[]{element.getStorageQuantity()}), x + 9, y + 1, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
                y += 8;
                ++moved;
            }
            if (element.getCraftQuantity() > 0L) {
                GuiCraftingPlan.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.CRAFTING_TABLE), x, y, 0.45f);
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, Minecraft.getInstance().font, IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.crafting", new Object[]{element.getCraftQuantity()}), x + 9, y + 1, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
                y += 8;
                ++moved;
            }
            if (element.getMissingQuantity() > 0L) {
                if (moved == 2) {
                    y -= 16;
                    x -= 44;
                }
                GuiCraftingPlan.renderItem(guiGraphics, new ItemStack((ItemLike)Blocks.BARRIER), x, y, 0.45f);
                IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, Minecraft.getInstance().font, IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_storage.missing", new Object[]{element.getMissingQuantity()}), x + 9, y + 1, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
            }
        } else {
            IModHelpers.get().getGuiHelpers().renderTooltipOptional(this.parentGui, guiGraphics, x, y, 50, IModHelpers.get().getGuiHelpers().getSlotSize(), mouseX, mouseY, () -> {
                String unlocalizedName = "gui.integratedterminals.craftingplan.status." + element.getStatus().name().toLowerCase(Locale.ENGLISH);
                return Optional.of(Lists.newArrayList((Object[])new Component[]{Component.translatable((String)unlocalizedName), Component.translatable((String)(unlocalizedName + ".desc"))}));
            });
        }
    }

    protected static void renderItem(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y, float scale) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)x, (float)y);
        guiGraphics.pose().scale(scale, scale);
        GuiGraphicsExtended renderItem = new GuiGraphicsExtended(guiGraphics);
        guiGraphics.renderItem(itemStack, 0, 0);
        renderItem.renderItemDecorations(Minecraft.getInstance().font, itemStack, 0, 0, "");
        guiGraphics.pose().popMatrix();
    }

    public static String getDurationString(long tickDuration) {
        long durationMs = tickDuration * 1000L / (long)IModHelpers.get().getMinecraftHelpers().getSecondInTicks();
        return IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_crafting_job.craftingplan.duration", new Object[]{DurationFormatUtils.formatDuration((long)durationMs, (String)"H:mm:ss", (boolean)true)});
    }

    public void drawGuiContainerBackgroundLayer(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        Font fontRenderer = Minecraft.getInstance().font;
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.label, this.guiLeft + this.getX() + 110 + 8, this.guiTop + this.getY() - 13, ARGB.opaque((int)0xFFFFFF));
        if (this.tickDuration >= 0L) {
            String durationString = GuiCraftingPlan.getDurationString(this.tickDuration);
            IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, fontRenderer, durationString, this.guiLeft + this.getX() + 200, this.guiTop + this.getY() - 14, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
        }
        if (this.channel != -1) {
            String channelString = IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", new Object[]{this.channel});
            IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, fontRenderer, channelString, this.guiLeft + this.getX() + 200, this.guiTop + this.getY() - 8, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
        }
        if (this.initiatorName != null) {
            String initiatorString = IModHelpers.get().getL10NHelpers().localize("gui.integratedterminals.terminal_crafting_job.craftingplan.owner", new Object[]{this.initiatorName});
            IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, fontRenderer, initiatorString, this.guiLeft + this.getX() - 4, this.guiTop + this.getY() - 14, 0.5f, ARGB.opaque((int)0xFFFFFF), true, Font.DisplayMode.NORMAL);
        }
        this.drawGuiContainerLayer(guiGraphics, this.guiLeft, this.guiTop, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND, partialTicks, mouseX, mouseY);
        this.scrollBar.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawGuiContainerLayer(guiGraphics, 0, 0, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND, 0.0f, mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.scrollBar.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        return this.scrollBar.mouseDragged(mouseX, mouseY, mouseButton, offsetX, offsetY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        int offsetY = 0;
        for (Element element : this.getVisibleElements()) {
            int x = this.guiLeft + this.getX() + this.getAbsoluteElementIndent(element);
            int y = this.guiTop + this.getY() + offsetY;
            offsetY += 18;
            if (!IModHelpers.get().getRenderHelpers().isPointInRegion(new Rectangle(x, y, 221, 16), new Point((int)mouseX, (int)mouseY))) continue;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            for (Element child : element.getChildren()) {
                child.setEnabled(!child.isEnabled());
            }
            this.refreshList();
            return true;
        }
        return false;
    }

    public static List<Element> getElements(ITerminalCraftingPlan<?> craftingPlan) {
        ArrayList elements = Lists.newArrayList();
        GuiCraftingPlan.addElements(null, 0, craftingPlan, elements);
        return elements;
    }

    protected static void addElements(@Nullable Element parent, int indent, ITerminalCraftingPlan<?> craftingPlan, List<Element> elements) {
        boolean valid = craftingPlan.getStatus().isValid() || !craftingPlan.getStorageIngredients().isEmpty() || !craftingPlan.getDependencies().isEmpty();
        int elementId = Objects.hash(craftingPlan.getId()) * 100;
        Element currentElement = new Element(elementId++, indent, craftingPlan.getOutputs().stream().map(Collections::singletonList).collect(Collectors.toList()), 0L, valid ? craftingPlan.getCraftingQuantity() : 0L, valid ? 0L : craftingPlan.getCraftingQuantity(), craftingPlan.getStatus().getColor(), craftingPlan.getStatus());
        if (parent != null) {
            parent.addChild(currentElement);
        }
        elements.add(currentElement);
        if (craftingPlan.getStatus() == TerminalCraftingJobStatus.PENDING_INPUTS) {
            for (List<IPrototypedIngredient<?, ?>> list : craftingPlan.getLastMissingIngredients()) {
                List<List<IPrototypedIngredient<?, ?>>> outputs = Collections.singletonList(list.stream().map(prototypedIngredient -> {
                    IIngredientMatcher matcher = prototypedIngredient.getComponent().getMatcher();
                    Object instance = matcher.withQuantity(prototypedIngredient.getPrototype(), matcher.getQuantity(prototypedIngredient.getPrototype()) * craftingPlan.getCraftingQuantity());
                    return new PrototypedIngredient(prototypedIngredient.getComponent(), instance, prototypedIngredient.getCondition());
                }).collect(Collectors.toList()));
                elements.add(currentElement.addChild(new Element(elementId++, indent + 1, outputs, 0L, 0L, craftingPlan.getCraftingQuantity(), TerminalCraftingJobStatus.INVALID.getColor(), TerminalCraftingJobStatus.INVALID)));
            }
        } else if (craftingPlan.getStatus() != TerminalCraftingJobStatus.CRAFTING) {
            for (IPrototypedIngredient iPrototypedIngredient : craftingPlan.getStorageIngredients()) {
                elements.add(currentElement.addChild(new Element(elementId++, indent + 1, Collections.singletonList(Collections.singletonList(iPrototypedIngredient)), iPrototypedIngredient.getComponent().getMatcher().getQuantity(iPrototypedIngredient.getPrototype()), 0L, 0L, TerminalCraftingJobStatus.FINISHED.getColor(), TerminalCraftingJobStatus.FINISHED)));
            }
        }
        for (ITerminalCraftingPlan iTerminalCraftingPlan : craftingPlan.getDependencies()) {
            GuiCraftingPlan.addElements(currentElement, indent + 1, iTerminalCraftingPlan, elements);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public static class Element {
        private final int id;
        private final int indent;
        private final List<List<IPrototypedIngredient<?, ?>>> outputs;
        private final long storageQuantity;
        private final long craftQuantity;
        private final long missingQuantity;
        private final int color;
        private final List<Element> children;
        private final TerminalCraftingJobStatus status;
        private boolean enabled;

        public Element(int id, int indent, List<List<IPrototypedIngredient<?, ?>>> outputs, long storageQuantity, long craftQuantity, long missingQuantity, int color, TerminalCraftingJobStatus status) {
            this.id = id;
            this.indent = indent;
            this.outputs = outputs;
            this.storageQuantity = storageQuantity;
            this.craftQuantity = craftQuantity;
            this.missingQuantity = missingQuantity;
            this.color = color;
            this.status = status;
            this.children = Lists.newArrayList();
            this.enabled = true;
        }

        public int getId() {
            return this.id;
        }

        public int getIndent() {
            return this.indent;
        }

        public List<List<IPrototypedIngredient<?, ?>>> getOutputs() {
            return this.outputs;
        }

        public long getStorageQuantity() {
            return this.storageQuantity;
        }

        public long getCraftQuantity() {
            return this.craftQuantity;
        }

        public long getMissingQuantity() {
            return this.missingQuantity;
        }

        public int getColor() {
            return this.color;
        }

        public Element addChild(Element element) {
            this.children.add(element);
            return element;
        }

        public List<Element> getChildren() {
            return this.children;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public TerminalCraftingJobStatus getStatus() {
            return this.status;
        }
    }
}

