/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.TagPathElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.slf4j.Logger;

public class TerminalStorageTabIngredientComponentCommon<T, M>
implements ITerminalStorageTabCommon,
IVariableFacade.IValidator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ContainerTerminalStorageBase containerTerminalStorage;
    private final ResourceLocation name;
    protected final IngredientComponent<T, M> ingredientComponent;
    private final int errorsValueId;
    private SimpleInventory inventory = null;
    private boolean dirtyInv;
    private final List<InventoryVariableEvaluator<ValueTypeOperator.ValueOperator>> variableEvaluators = Lists.newArrayList();
    private final List<IVariable<ValueTypeOperator.ValueOperator>> variables = Lists.newArrayList();
    private int variableSlotNumberStart;
    private int variableSlotNumberEnd;

    public TerminalStorageTabIngredientComponentCommon(ContainerTerminalStorageBase containerTerminalStorage, ResourceLocation name, IngredientComponent<T, M> ingredientComponent) {
        this.containerTerminalStorage = containerTerminalStorage;
        this.name = name;
        this.ingredientComponent = ingredientComponent;
        this.errorsValueId = containerTerminalStorage.getNextValueId();
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public List<Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback>> loadSlots(AbstractContainerMenu container, int startIndex, Player player, Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventoryOptional, ValueDeseralizationContext valueDeseralizationContext) {
        ITerminalStorageTabCommon.IVariableInventory variableInventory = variableInventoryOptional.get();
        ArrayList slots = Lists.newArrayList();
        this.variableSlotNumberStart = startIndex;
        this.inventory = new SimpleInventory(3, 1);
        variableInventory.loadNamedInventory(this.getName().toString(), (Container)this.inventory, valueDeseralizationContext.holderLookupProvider());
        this.variableEvaluators.clear();
        int i = 0;
        while (i < this.inventory.getContainerSize()) {
            final int slot = i++;
            this.variableEvaluators.add(new InventoryVariableEvaluator<ValueTypeOperator.ValueOperator>((Container)this.inventory, slot, valueDeseralizationContext, (IValueType)ValueTypes.OPERATOR){

                public void onErrorsChanged() {
                    super.onErrorsChanged();
                    TerminalStorageTabIngredientComponentCommon.this.setLocalErrors(slot, this.getErrors());
                }
            });
        }
        this.variableSlotNumberEnd = startIndex + this.inventory.getContainerSize();
        this.inventory.addDirtyMarkListener(() -> {
            this.dirtyInv = true;
        });
        slots.add(Pair.of((Object)new SlotVariable((Container)this.inventory, 0, 0, 0), factors -> Pair.of((Object)(factors.offsetX() + factors.gridXSize() / 2 + factors.playerInventoryOffsetX() + 139), (Object)(factors.offsetY() + factors.gridYSize() + factors.playerInventoryOffsetY() + 63))));
        slots.add(Pair.of((Object)new SlotVariable((Container)this.inventory, 1, 0, 0), factors -> Pair.of((Object)(factors.offsetX() + factors.gridXSize() / 2 + factors.playerInventoryOffsetX() + 139), (Object)(factors.offsetY() + factors.gridYSize() + factors.playerInventoryOffsetY() + 81))));
        slots.add(Pair.of((Object)new SlotVariable((Container)this.inventory, 2, 0, 0), factors -> Pair.of((Object)(factors.offsetX() + factors.gridXSize() / 2 + factors.playerInventoryOffsetX() + 139), (Object)(factors.offsetY() + factors.gridYSize() + factors.playerInventoryOffsetY() + 99))));
        this.dirtyInv = true;
        return slots;
    }

    public int getVariableSlotNumberStart() {
        return this.variableSlotNumberStart;
    }

    public int getVariableSlotNumberEnd() {
        return this.variableSlotNumberEnd;
    }

    @Override
    public void onUpdate(AbstractContainerMenu container, Player player, Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventory) {
        if (this.dirtyInv && !player.level().isClientSide) {
            this.dirtyInv = false;
            ContainerTerminalStorageBase containerTerminalStorage = (ContainerTerminalStorageBase)container;
            variableInventory.get().saveNamedInventory(this.getName().toString(), (Container)this.inventory, (HolderLookup.Provider)player.registryAccess());
            INetwork network = containerTerminalStorage.getNetwork().get();
            this.clearGlobalErrors();
            this.variables.clear();
            if (network == null) {
                this.addError(Component.translatable((String)"general.integrateddynamics.error.no_network"));
            } else {
                for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                    InventoryVariableEvaluator<ValueTypeOperator.ValueOperator> evaluator = this.variableEvaluators.get(i);
                    evaluator.refreshVariable(network, false);
                    IVariable variable = evaluator.getVariable(network);
                    if (variable != null) {
                        variable.addInvalidationListener(() -> this.inventory.setChanged());
                        this.variables.add((IVariable<ValueTypeOperator.ValueOperator>)variable);
                    }
                    containerTerminalStorage.onVariableContentsUpdated(network, variable);
                }
            }
            TerminalStorageTabIngredientComponentServer tabServer = (TerminalStorageTabIngredientComponentServer)containerTerminalStorage.getTabServer(this.getName().toString());
            tabServer.updateFilter(this.variables, this);
            tabServer.reApplyFilter(null);
        }
    }

    protected HolderLookup.Provider getHolderLookupProvider() {
        return this.containerTerminalStorage.getPlayerIInventory().player.registryAccess();
    }

    public void addError(MutableComponent error) {
        List<Component> errors = this.getGlobalErrors();
        errors.add((Component)error);
        this.setGlobalErrors(errors);
    }

    protected void setGlobalErrors(List<Component> errors) {
        CompoundTag tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        tag = tag == null ? new CompoundTag() : tag.copy();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(tag), LOGGER);){
            TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.getHolderLookupProvider());
            NBTClassType.writeNbt(List.class, (String)"v", errors, (ValueOutput)valueOutput);
            tag.put(this.getName().toString() + ":globalErrors", (Tag)valueOutput.buildResult());
        }
        this.containerTerminalStorage.setValue(this.errorsValueId, tag);
    }

    public List<Component> getGlobalErrors() {
        CompoundTag tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        if (tag == null) {
            return Lists.newArrayList();
        }
        return tag.getCompound(this.getName().toString() + ":globalErrors").map(subTag -> {
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(subTag), LOGGER);){
                ValueInput input = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.getHolderLookupProvider(), (CompoundTag)subTag);
                List list = (List)NBTClassType.readNbt(List.class, (String)"v", (ValueInput)input);
                return list;
            }
        }).orElseGet(Collections::emptyList);
    }

    public void clearGlobalErrors() {
        this.setGlobalErrors(Lists.newArrayList());
    }

    public void setLocalErrors(int slot, List<MutableComponent> errors) {
        CompoundTag tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        tag = tag == null ? new CompoundTag() : tag.copy();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(tag), LOGGER);){
            TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.getHolderLookupProvider());
            NBTClassType.writeNbt(List.class, (String)"v", errors, (ValueOutput)valueOutput);
            tag.put(this.getName().toString() + ":localErrors" + slot, (Tag)valueOutput.buildResult());
        }
        this.containerTerminalStorage.setValue(this.errorsValueId, tag);
    }

    public List<Component> getLocalErrors(int slot) {
        CompoundTag tag = this.containerTerminalStorage.getValue(this.errorsValueId);
        if (tag == null) {
            return Lists.newArrayList();
        }
        return tag.getCompound(this.getName().toString() + ":localErrors" + slot).map(subTag -> {
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(subTag), LOGGER);){
                ValueInput input = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.getHolderLookupProvider(), (CompoundTag)subTag);
                List list = (List)NBTClassType.readNbt(List.class, (String)"v", (ValueInput)input);
                return list;
            }
        }).orElseGet(Collections::emptyList);
    }

    public boolean hasErrors() {
        return !this.getGlobalErrors().isEmpty();
    }
}

