/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.item;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.item.TagPathElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.part.PartTypeConnectorOmniDirectional;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItem;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.slf4j.Logger;

public class ItemTerminalStoragePortable
extends ItemGui {
    private static final Logger LOGGER = LogUtils.getLogger();

    public ItemTerminalStoragePortable(Item.Properties properties) {
        super(properties);
    }

    public void openGuiForItemIndex(Level world, ServerPlayer player, ItemLocation itemLocation) {
        if (world.isClientSide()) {
            super.openGuiForItemIndex(world, player, itemLocation);
        } else {
            ItemStack itemStack = itemLocation.getItemStack((Player)player);
            int groupId = ItemTerminalStoragePortable.getGroupId(itemStack);
            if (groupId >= 0) {
                Optional<INetwork> network = ContainerTerminalStorageItem.getNetworkFromItem(itemStack);
                if (network.isPresent()) {
                    super.openGuiForItemIndex(world, player, itemLocation);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"item.integratedterminals.terminal_storage_portable.status.invalid_network"), true);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"item.integratedterminals.terminal_storage_portable.status.no_network"), true);
            }
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockRayTraceResultComponent rayTraceResult;
        BlockState blockState;
        if (!context.getLevel().isClientSide() && context.getPlayer() != null && (blockState = context.getLevel().getBlockState(context.getClickedPos())).getBlock() == org.cyclops.integrateddynamics.RegistryEntries.BLOCK_CABLE.get() && (rayTraceResult = ((BlockCable)blockState.getBlock()).getSelectedShape(blockState, (BlockGetter)context.getLevel(), context.getClickedPos(), CollisionContext.of((Entity)context.getPlayer())).rayTrace(context.getClickedPos(), (Entity)context.getPlayer())) != null) {
            Direction partDirection = rayTraceResult.getComponent().getRaytraceDirection();
            PartPos partPos = PartPos.of((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)partDirection);
            PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)partPos);
            if (partStateHolder != null && partStateHolder.getPart() == PartTypes.CONNECTOR_OMNI) {
                PartTypeConnectorOmniDirectional.State state = (PartTypeConnectorOmniDirectional.State)partStateHolder.getState();
                ItemTerminalStoragePortable.setGroupId(stack, state.getGroupId());
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.integratedterminals.terminal_storage_portable.status.linked"), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, ItemLocation itemLocation) {
        return new NamedContainerProviderItem(itemLocation, itemLocation.getItemStack(playerEntity).getHoverName(), (id, playerInventory, itemLocation1) -> new ContainerTerminalStorageItem(id, playerInventory, itemLocation1, Optional.empty(), ItemTerminalStoragePortable.getTerminalStorageState(itemLocation.getItemStack(playerEntity), playerEntity, itemLocation1)));
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerTerminalStorageItem.class;
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, ServerPlayer player, ItemLocation itemLocation) {
        super.writeExtraGuiData(packetBuffer, world, player, itemLocation);
        packetBuffer.writeBoolean(false);
        ItemTerminalStoragePortable.getTerminalStorageState(itemLocation.getItemStack((Player)player), (Player)player, itemLocation).writeToPacketBuffer(packetBuffer);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.getItem() != newStack.getItem();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltip, flagIn);
        int groupId = ItemTerminalStoragePortable.getGroupId(stack);
        if (groupId >= 0) {
            tooltip.accept((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.monodirectionalconnector.group", (Object[])new Object[]{groupId}));
        }
    }

    public static int getGroupId(ItemStack itemStack) {
        return Objects.requireNonNullElse((Integer)itemStack.get((Supplier)org.cyclops.integrateddynamics.RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP), -1);
    }

    public static void setGroupId(ItemStack itemStack, int groupId) {
        itemStack.set((Supplier)org.cyclops.integrateddynamics.RegistryEntries.DATACOMPONENT_OMNIDIRECTIONAL_GROUP, (Object)groupId);
    }

    public static ITerminalStorageTabCommon.IVariableInventory getVariableInventory(final ItemStack itemStack) {
        CompoundTag tagInventories = (CompoundTag)itemStack.get(RegistryEntries.COMPONENT_TERMINAL_STORAGE_INVENTORIES);
        if (tagInventories == null) {
            tagInventories = new CompoundTag();
        } else {
            tagInventories.copy();
        }
        final CompoundTag finalTagInventories = tagInventories;
        return new ITerminalStorageTabCommon.IVariableInventory(){

            @Override
            public NonNullList<ItemStack> getNamedInventory(String name, HolderLookup.Provider holderLookupProvider) {
                CompoundTag tag = (CompoundTag)finalTagInventories.getCompound(name).orElseThrow();
                try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(tag), LOGGER);){
                    ValueInput input = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)holderLookupProvider, (CompoundTag)tag);
                    NonNullList list = NonNullList.withSize((int)((Integer)input.getInt("itemCount").orElseThrow()), (Object)ItemStack.EMPTY);
                    ContainerHelper.loadAllItems((ValueInput)input, (NonNullList)list);
                    NonNullList nonNullList = list;
                    return nonNullList;
                }
            }

            @Override
            public void setNamedInventory(String name, NonNullList<ItemStack> inventory, HolderLookup.Provider holderLookupProvider) {
                try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(new CompoundTag()), LOGGER);){
                    TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)holderLookupProvider);
                    valueOutput.putString("tabName", name);
                    valueOutput.putInt("itemCount", inventory.size());
                    ContainerHelper.saveAllItems((ValueOutput)valueOutput, inventory);
                    CompoundTag tag = valueOutput.buildResult();
                    finalTagInventories.put(name, (Tag)tag);
                    itemStack.set(RegistryEntries.COMPONENT_TERMINAL_STORAGE_INVENTORIES, (Object)finalTagInventories.copy());
                }
            }
        };
    }

    public static TerminalStorageState getTerminalStorageState(ItemStack itemStack, Player player, ItemLocation itemLocation) {
        CompoundTag tagStates = (CompoundTag)itemStack.get(RegistryEntries.COMPONENT_TERMINAL_STORAGE_STATE);
        tagStates = tagStates == null ? new CompoundTag() : tagStates.copy();
        String playerKey = player.getUUID().toString();
        Wrapper stateWrapped = new Wrapper();
        CompoundTag finalTagStates = tagStates;
        IDirtyMarkListener dirtyMarkListener = () -> {
            finalTagStates.put(playerKey, (Tag)((TerminalStorageState)stateWrapped.get()).getTag());
            itemStack.set(RegistryEntries.COMPONENT_TERMINAL_STORAGE_STATE, (Object)finalTagStates.copy());
        };
        if (!tagStates.contains(playerKey)) {
            TerminalStorageState state = TerminalStorageState.getPlayerDefault(player, dirtyMarkListener);
            stateWrapped.set((Object)state);
            tagStates.put(playerKey, (Tag)state.getTag());
            return state;
        }
        TerminalStorageState state = new TerminalStorageState((CompoundTag)tagStates.getCompound(playerKey).orElseThrow(), dirtyMarkListener);
        stateWrapped.set((Object)state);
        return state;
    }
}

