/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.PacketCodecs;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobsPlan;
import org.cyclops.integratedterminals.part.PartTypeTerminalCraftingJob;
import org.cyclops.integratedterminals.part.PartTypes;

public class OpenCraftingJobsPlanGuiPacket
extends PacketCodec<OpenCraftingJobsPlanGuiPacket> {
    public static final CustomPacketPayload.Type<OpenCraftingJobsPlanGuiPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"open_crafting_jobs_plan_gui"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenCraftingJobsPlanGuiPacket> CODEC = OpenCraftingJobsPlanGuiPacket.getCodec(OpenCraftingJobsPlanGuiPacket::new);
    @CodecField
    private BlockPos pos;
    @CodecField
    private Direction side;
    @CodecField
    private int channel;
    @CodecField
    private String craftingPlanHandler;
    @CodecField
    private CompoundTag craftingJobId;

    public OpenCraftingJobsPlanGuiPacket() {
        super(ID);
    }

    public OpenCraftingJobsPlanGuiPacket(CraftingJobGuiData craftingPlanGuiData) {
        super(ID);
        this.pos = craftingPlanGuiData.getPos();
        this.side = craftingPlanGuiData.getSide();
        this.channel = craftingPlanGuiData.getChannel();
        this.craftingPlanHandler = craftingPlanGuiData.getHandler().getId().toString();
        this.craftingJobId = IModHelpers.get().getMinecraftHelpers().valueOutputToNbt(o -> craftingPlanGuiData.getHandler().serializeCraftingJobId((ValueOutput)o, craftingPlanGuiData.getCraftingJob()));
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ITerminalStorageTabIngredientCraftingHandler handler = this.getHandler();
        final CraftingJobGuiData craftingJobGuiData = new CraftingJobGuiData(this.pos, this.side, this.channel, handler, IModHelpers.get().getMinecraftHelpers().valueInputFromNbt(this.craftingJobId, (HolderLookup.Provider)world.registryAccess(), handler::deserializeCraftingJobId));
        final PartPos partPos = PartPos.of((Level)world, (BlockPos)this.pos, (Direction)this.side);
        MenuProvider containerProvider = new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"");
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)partPos);
                return new ContainerTerminalCraftingJobsPlan(id, playerInventory, (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (PartTypeTerminalCraftingJob)((Object)data.getMiddle()), craftingJobGuiData);
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        };
        player.openMenu(containerProvider, packetBuffer -> {
            PacketCodecs.write((RegistryFriendlyByteBuf)packetBuffer, (Object)partPos);
            packetBuffer.writeUtf(PartTypes.TERMINAL_CRAFTING_JOB.getUniqueName().toString());
            craftingJobGuiData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    protected ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(ResourceLocation.parse((String)this.craftingPlanHandler));
    }

    public static void send(BlockPos pos, Direction side, int channel, HandlerWrappedTerminalCraftingPlan craftingPlan) {
        CraftingJobGuiData data = new CraftingJobGuiData(pos, side, channel, craftingPlan.getHandler(), craftingPlan.getCraftingPlanFlat().getId());
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new OpenCraftingJobsPlanGuiPacket(data));
    }
}

