/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.cyclopscore.ingredient.collection.IngredientArrayList;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollections;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientChangeEventPacket
extends PacketCodec<TerminalStorageIngredientChangeEventPacket> {
    public static final CustomPacketPayload.Type<TerminalStorageIngredientChangeEventPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_change_event"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientChangeEventPacket> CODEC = TerminalStorageIngredientChangeEventPacket.getCodec(TerminalStorageIngredientChangeEventPacket::new);
    @CodecField
    private String tabId;
    @CodecField
    private CompoundTag changeData;
    @CodecField
    private int channel;
    @CodecField
    private boolean enabled;

    public TerminalStorageIngredientChangeEventPacket() {
        super(ID);
    }

    public TerminalStorageIngredientChangeEventPacket(HolderLookup.Provider lookupProvider, String tabId, IIngredientComponentStorageObservable.StorageChangeEvent<?, ?> event, boolean enabled) {
        super(ID);
        this.tabId = tabId;
        IIngredientComponentStorageObservable.Change changeType = event.getChangeType();
        IIngredientCollection instances = event.getInstances();
        CompoundTag serialized = IModHelpers.get().getMinecraftHelpers().valueOutputToNbt(o -> IngredientCollections.serialize((ValueOutput)o, (IIngredientCollection)instances), lookupProvider);
        serialized.putInt("changeType", changeType.ordinal());
        this.changeData = serialized;
        this.channel = event.getChannel();
        this.enabled = enabled;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
        if (player.containerMenu instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.containerMenu;
            IIngredientComponentStorageObservable.Change changeType = IIngredientComponentStorageObservable.Change.values()[(Integer)this.changeData.getInt("changeType").orElseThrow()];
            IngredientArrayList ingredients = (IngredientArrayList)IModHelpers.get().getMinecraftHelpers().valueInputFromNbt(this.changeData, (HolderLookup.Provider)world.registryAccess(), IngredientCollections::deserialize);
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            tab.onChange(this.channel, changeType, ingredients, this.enabled);
            if (this.tabId.equals(IngredientComponents.ITEMSTACK.getName().toString())) {
                TerminalStorageTabIngredientComponentClient tabCrafting = (TerminalStorageTabIngredientComponentClient)container.getTabClient(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString());
                tabCrafting.onChange(this.channel, changeType, ingredients, this.enabled);
            }
            container.refreshChannelStrings();
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

