/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.item.TagPathElement;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.slf4j.Logger;

public class TerminalStorageIngredientCraftingOptionsPacket
extends PacketCodec<TerminalStorageIngredientCraftingOptionsPacket> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<TerminalStorageIngredientCraftingOptionsPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_crafting_options"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientCraftingOptionsPacket> CODEC = TerminalStorageIngredientCraftingOptionsPacket.getCodec(TerminalStorageIngredientCraftingOptionsPacket::new);
    @CodecField
    private String tabId;
    @CodecField
    private int channel;
    @CodecField
    private CompoundTag data;
    @CodecField
    private boolean reset;
    @CodecField
    private boolean firstChannel;

    public TerminalStorageIngredientCraftingOptionsPacket() {
        super(ID);
    }

    public <T> TerminalStorageIngredientCraftingOptionsPacket(HolderLookup.Provider lookupProvider, String tabId, int channel, Collection<HandlerWrappedTerminalCraftingOption<T>> craftingOptions, boolean reset, boolean firstChannel) {
        super(ID);
        this.tabId = tabId;
        this.channel = channel;
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(new CompoundTag()), LOGGER);){
            TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)lookupProvider);
            ValueOutput.ValueOutputList list = valueOutput.childrenList("craftingOptions");
            for (HandlerWrappedTerminalCraftingOption<T> option : craftingOptions) {
                HandlerWrappedTerminalCraftingOption.serialize(list.addChild(), option);
            }
            this.data = valueOutput.buildResult();
        }
        this.reset = reset;
        this.firstChannel = firstChannel;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
        if (player.containerMenu instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.containerMenu;
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            IngredientComponent ingredientComponent = tab.getIngredientComponent();
            ArrayList craftingOptions = Lists.newArrayList();
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(this.data), LOGGER);){
                ValueInput input = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)this.data);
                for (ValueInput craftingOption : (ValueInput.ValueInputList)input.childrenList("craftingOptions").orElseThrow()) {
                    HandlerWrappedTerminalCraftingOption option = HandlerWrappedTerminalCraftingOption.deserialize(craftingOption, ingredientComponent);
                    craftingOptions.add(option);
                }
            }
            tab.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
            if (this.tabId.equals(IngredientComponents.ITEMSTACK.getName().toString())) {
                TerminalStorageTabIngredientComponentClient tabCrafting = (TerminalStorageTabIngredientComponentClient)container.getTabClient(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString());
                tabCrafting.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
            }
            container.refreshChannelStrings();
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

