/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.mojang.logging.LogUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.item.TagPathElement;
import org.cyclops.integratedterminals.api.terminalstorage.TerminalClickType;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.slf4j.Logger;

public class TerminalStorageIngredientSlotClickPacket<T>
extends PacketCodec<TerminalStorageIngredientSlotClickPacket<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final CustomPacketPayload.Type<TerminalStorageIngredientSlotClickPacket<?>> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integratedterminals", (String)"terminal_storage_ingredient_slot_click"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TerminalStorageIngredientSlotClickPacket<?>> CODEC = TerminalStorageIngredientSlotClickPacket.getCodec(TerminalStorageIngredientSlotClickPacket::new);
    @CodecField
    private String tabId;
    @CodecField
    private String ingredientName;
    @CodecField
    private int clickType;
    @CodecField
    private int channel;
    @CodecField
    private CompoundTag hoveringStorageInstanceData;
    @CodecField
    private int hoveredContainerSlot;
    @CodecField
    private long moveQuantityPlayerSlot;
    @CodecField
    private CompoundTag activeStorageInstanceData;
    @CodecField
    private boolean transferFullSelection;

    public TerminalStorageIngredientSlotClickPacket() {
        super(ID);
    }

    public TerminalStorageIngredientSlotClickPacket(HolderLookup.Provider lookupProvider, String tabId, IngredientComponent<T, ?> component, TerminalClickType clickType, int channel, T hoveringStorageInstance, int hoveredContainerSlot, long moveQuantityPlayerSlot, T activeStorageInstance, boolean transferFullSelection) {
        super(ID);
        TagValueOutput valueOutput;
        this.tabId = tabId;
        this.clickType = clickType.ordinal();
        this.ingredientName = component.getName().toString();
        this.channel = channel;
        IIngredientSerializer serializer = this.getComponent().getSerializer();
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(new CompoundTag()), LOGGER);){
            valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)lookupProvider);
            serializer.serializeInstance((ValueOutput)valueOutput, hoveringStorageInstance);
            this.hoveringStorageInstanceData = valueOutput.buildResult();
        }
        this.hoveredContainerSlot = hoveredContainerSlot;
        this.moveQuantityPlayerSlot = moveQuantityPlayerSlot;
        scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(new CompoundTag()), LOGGER);
        try {
            valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)lookupProvider);
            serializer.serializeInstance((ValueOutput)valueOutput, activeStorageInstance);
            this.activeStorageInstanceData = valueOutput.buildResult();
        }
        finally {
            scopedCollector.close();
        }
        this.transferFullSelection = transferFullSelection;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        if (player.containerMenu instanceof ContainerTerminalStorageBase) {
            Object activeInstance;
            Object hoveringStorageInstance;
            ValueInput input;
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.containerMenu;
            TerminalStorageTabIngredientComponentServer tab = (TerminalStorageTabIngredientComponentServer)container.getTabServer(this.tabId);
            IIngredientSerializer serializer = this.getComponent().getSerializer();
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(this.hoveringStorageInstanceData), LOGGER);){
                input = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)this.hoveringStorageInstanceData);
                hoveringStorageInstance = serializer.deserializeInstance(input);
            }
            scopedCollector = new ProblemReporter.ScopedCollector((ProblemReporter.PathElement)new TagPathElement(this.activeStorageInstanceData), LOGGER);
            try {
                input = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)this.activeStorageInstanceData);
                activeInstance = serializer.deserializeInstance(input);
            }
            finally {
                scopedCollector.close();
            }
            tab.handleStorageSlotClick((AbstractContainerMenu)container, player, this.getClickType(), this.getChannel(), hoveringStorageInstance, this.hoveredContainerSlot, this.moveQuantityPlayerSlot, activeInstance, this.transferFullSelection);
        }
    }

    public TerminalClickType getClickType() {
        return TerminalClickType.values()[this.clickType];
    }

    public IngredientComponent<T, ?> getComponent() {
        IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(ResourceLocation.parse((String)this.ingredientName));
        if (ingredientComponent == null) {
            throw new IllegalArgumentException("No ingredient component with the given name was found: " + this.ingredientName);
        }
        return ingredientComponent;
    }

    public int getChannel() {
        return this.channel;
    }
}

