/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.ingredient.storage.IngredientComponentStorageWrapperHandlerItemStack;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionHelpers;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminalscompat.IntegratedTerminalsCompat;
import org.cyclops.integratedterminalscompat.modcompat.common.RecipeInputSlot;
import org.cyclops.integratedterminalscompat.modcompat.common.RecipeTransferResult;
import org.cyclops.integratedterminalscompat.network.packet.TerminalStorageIngredientItemStackCraftingGridSetRecipe;

public class RecipeTransferHelpers {
    private static final long RECIPE_ERROR_CACHE_TIME = 60L;
    private static final Cache<Object, Optional<RecipeTransferResult<?>>> recipeErrorCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();

    public static Optional<Pair<TerminalStorageTabIngredientComponentItemStackCraftingCommon, TerminalStorageTabIngredientComponentClient<ItemStack, Integer>>> getTabs(ContainerTerminalStorageBase<?> container) {
        if (Objects.equals(container.getSelectedTab(), TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString())) {
            ITerminalStorageTabCommon tabCommon = container.getTabCommon(container.getSelectedTab());
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)tabCommon;
            TerminalStorageTabIngredientComponentClient tabClient = (TerminalStorageTabIngredientComponentClient)container.getTabClient(container.getSelectedTab());
            return Optional.of(Pair.of((Object)tabCommonCrafting, (Object)tabClient));
        }
        return Optional.empty();
    }

    public static int getCurrentChangeId(TerminalStorageTabIngredientComponentClient<?, ?> tabClient, Player player) {
        return tabClient.getLastChangeId() + player.getInventory().getTimesChanged();
    }

    public static <T extends RecipeInputSlot> Optional<RecipeTransferResult<T>> getMissingItems(Object cacheKey, ContainerTerminalStorageBase<?> container, Iterable<T> recipeInputSlots, Player player, TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting, TerminalStorageTabIngredientComponentClient<?, ?> tabClient, Function<ItemStack, Integer> itemStackToMatchCondition, Supplier<Integer> getId, Consumer<Integer> onChangeId) {
        Callable<Optional> missingItemsSupplier = () -> RecipeTransferHelpers.getMissingItemsUncached(container, recipeInputSlots, player, tabCommonCrafting, itemStackToMatchCondition, onChangeId);
        if (getId.get() != RecipeTransferHelpers.getCurrentChangeId(tabClient, player)) {
            recipeErrorCache.invalidateAll();
        }
        try {
            return (Optional)recipeErrorCache.get(cacheKey, missingItemsSupplier);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends RecipeInputSlot> Optional<RecipeTransferResult<T>> getMissingItemsUncached(ContainerTerminalStorageBase<?> container, Iterable<T> recipeInputSlots, Player player, TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting, Function<ItemStack, Integer> itemStackToMatchCondition, Consumer<Integer> onChangeId) {
        TerminalStorageTabIngredientComponentClient tabClient = (TerminalStorageTabIngredientComponentClient)container.getTabClient(container.getSelectedTab());
        IngredientCollectionPrototypeMap hayStackCraftingGrid = new IngredientCollectionPrototypeMap(IngredientComponent.ITEMSTACK);
        for (int slot = 0; slot < tabCommonCrafting.getInventoryCrafting().getContainerSize(); ++slot) {
            hayStackCraftingGrid.add((Object)tabCommonCrafting.getInventoryCrafting().getItem(slot));
        }
        IngredientCollectionPrototypeMap hayStackPlayer = new IngredientCollectionPrototypeMap(IngredientComponent.ITEMSTACK);
        hayStackPlayer.addAll((Iterable)player.getInventory().getNonEquipmentItems());
        IIngredientCollapsedCollectionMutable hayStack = IngredientCollectionHelpers.createCollapsedCollection((IngredientComponent)IngredientComponent.ITEMSTACK);
        IIngredientCollapsedCollectionMutable hayStackCraftable = IngredientCollectionHelpers.createCollapsedCollection((IngredientComponent)IngredientComponent.ITEMSTACK);
        hayStack.addAll(tabClient.getRawUnfilteredIngredientsView(container.getSelectedChannel()));
        Collection craftingOptions = tabClient.getCraftingOptions(container.getSelectedChannel());
        if (craftingOptions != null) {
            hayStackCraftable.addAll(craftingOptions.stream().flatMap(option -> tabClient.getUniqueCraftingOptionOutputs(option.getCraftingOption()).stream()).toList());
        }
        ArrayList slotsMissingItems = Lists.newArrayList();
        ArrayList slotsMissingCraftableItems = Lists.newArrayList();
        for (RecipeInputSlot slot : recipeInputSlots) {
            if (slot.isEmpty()) continue;
            boolean found = false;
            boolean craftable = false;
            for (ItemStack itemStack : slot) {
                int matchCondition;
                if (hayStackCraftingGrid.contains((Object)itemStack, (Object)(matchCondition = itemStackToMatchCondition.apply(itemStack).intValue()))) {
                    hayStackPlayer.remove((Object)itemStack);
                    found = true;
                    break;
                }
                if (hayStackPlayer.contains((Object)itemStack, (Object)matchCondition)) {
                    hayStackPlayer.remove((Object)itemStack);
                    found = true;
                    break;
                }
                if (hayStack.contains((Object)itemStack, (Object)matchCondition)) {
                    hayStack.remove((Object)itemStack);
                    found = true;
                    break;
                }
                if (!hayStackCraftable.contains((Object)itemStack, (Object)matchCondition)) continue;
                craftable = true;
            }
            if (found) continue;
            if (craftable) {
                slotsMissingCraftableItems.add(slot);
                continue;
            }
            slotsMissingItems.add(slot);
        }
        onChangeId.accept(RecipeTransferHelpers.getCurrentChangeId(tabClient, player));
        if (!slotsMissingItems.isEmpty() || !slotsMissingCraftableItems.isEmpty()) {
            return Optional.of(new RecipeTransferResult(slotsMissingItems, slotsMissingCraftableItems));
        }
        return Optional.empty();
    }

    public static <T extends RecipeInputSlot> void transferRecipe(ContainerTerminalStorageBase<?> container, Iterable<T> recipeInputSlots, Player player, TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommonCrafting, Function<ItemStack, Integer> itemStackToMatchCondition, boolean maxTransfer) {
        IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper playerInventory = new IngredientComponentStorageWrapperHandlerItemStack.ComponentStorageWrapper(IngredientComponent.ITEMSTACK, (IItemHandler)new InvWrapper((Container)player.getInventory()));
        HashMap slottedIngredientsFromPlayer = Maps.newHashMap();
        HashMap slottedIngredientsFromStorage = Maps.newHashMap();
        int slotOffset = tabCommonCrafting.getSlotCrafting().index;
        int slotId = 0;
        for (RecipeInputSlot recipeSlot : recipeInputSlots) {
            if (!recipeSlot.isEmpty()) {
                boolean found = false;
                for (ItemStack itemStack2 : recipeSlot) {
                    int matchCondition;
                    if (playerInventory.extract(itemStack2, Integer.valueOf(matchCondition = itemStackToMatchCondition.apply(itemStack2).intValue()), true).isEmpty()) continue;
                    found = true;
                    ItemStack extracted = playerInventory.extract(itemStack2, Integer.valueOf(matchCondition), false);
                    Slot slot = container.getSlot(slotId + slotOffset);
                    slot.set(extracted);
                    slottedIngredientsFromPlayer.put(slotId, Pair.of((Object)itemStack2, (Object)itemStackToMatchCondition.apply(itemStack2)));
                    break;
                }
                if (!found) {
                    slottedIngredientsFromStorage.put(slotId, Streams.stream((Iterable)recipeSlot).map(itemStack -> Pair.of((Object)itemStack, (Object)((Integer)itemStackToMatchCondition.apply((ItemStack)itemStack)))).collect(Collectors.toList()));
                }
            }
            ++slotId;
        }
        IntegratedTerminalsCompat._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridSetRecipe(container.getSelectedTab(), container.getSelectedChannel(), maxTransfer, slottedIngredientsFromPlayer, slottedIngredientsFromStorage, AbstractContainerScreen.hasControlDown()));
    }
}

