/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import org.cyclops.integratedterminalscompat.modcompat.common.RecipeInputSlot;

public class RecipeTransferResult<T extends RecipeInputSlot> {
    public static final boolean HAS_CMD = System.getProperty("os.name").equals("Mac OS X");
    public static final int SLOT_COLOR_MISSING = ARGB.color((int)100, (int)255, (int)0, (int)0);
    public static final int SLOT_COLOR_CRAFTABLE = ARGB.color((int)100, (int)0, (int)0, (int)255);
    public static final int HIGHLIGHT_COLOR_FAIL = ARGB.color((int)100, (int)255, (int)0, (int)0);
    public static final int HIGHLIGHT_COLOR_CRAFTABLE = ARGB.color((int)100, (int)0, (int)0, (int)255);
    public static final int HIGHLIGHT_COLOR_CRAFTABLE_PARTIAL = ARGB.color((int)100, (int)255, (int)125, (int)0);
    private final List<Component> message = new ArrayList<Component>();
    private final Collection<T> slotsMissing;
    private final Collection<T> slotsCraftable;
    private final int color;

    public RecipeTransferResult(Collection<T> slotsMissing, Collection<T> slotsCraftable) {
        this.slotsMissing = slotsMissing;
        this.slotsCraftable = slotsCraftable;
        if (slotsCraftable.isEmpty() && slotsMissing.isEmpty()) {
            this.color = HIGHLIGHT_COLOR_CRAFTABLE;
        } else if (slotsMissing.isEmpty()) {
            this.message.add((Component)Component.translatable((String)"gui.integratedterminalscompat.terminal_storage.jei.transfer.craftable").withStyle(ChatFormatting.RED));
            this.message.add((Component)Component.translatable((String)(HAS_CMD ? "gui.integratedterminalscompat.terminal_storage.jei.transfer.craft.info_cmd" : "gui.integratedterminalscompat.terminal_storage.jei.transfer.craft.info")).withStyle(ChatFormatting.ITALIC));
            this.color = HIGHLIGHT_COLOR_CRAFTABLE;
        } else if (!slotsCraftable.isEmpty()) {
            this.message.add((Component)Component.translatable((String)"gui.integratedterminalscompat.terminal_storage.jei.transfer.craftable_partial").withStyle(ChatFormatting.RED));
            this.message.add((Component)Component.translatable((String)(HAS_CMD ? "gui.integratedterminalscompat.terminal_storage.jei.transfer.craft.info_cmd" : "gui.integratedterminalscompat.terminal_storage.jei.transfer.craft.info")).withStyle(ChatFormatting.ITALIC));
            this.color = HIGHLIGHT_COLOR_CRAFTABLE_PARTIAL;
        } else {
            this.message.add((Component)Component.translatable((String)"gui.integratedterminalscompat.terminal_storage.jei.transfer.missing").withStyle(ChatFormatting.ITALIC));
            this.color = HIGHLIGHT_COLOR_FAIL;
        }
    }

    public int getButtonHighlightColor() {
        return this.color;
    }

    public List<Component> getMessage() {
        return this.message;
    }

    public Collection<T> getSlotsCraftable() {
        return this.slotsCraftable;
    }

    public Collection<T> getSlotsMissing() {
        return this.slotsMissing;
    }
}

