/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.rei;

import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.screen.FocusedStackProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageScreenSizeEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientLoadButtonsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientSearchFieldUpdateEvent;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.part.PartTypes;
import org.cyclops.integratedterminalscompat.modcompat.common.button.TerminalButtonItemStackCraftingGridSearchSync;
import org.cyclops.integratedterminalscompat.modcompat.rei.terminalstorage.TerminalStorageReiFocusedStackProvider;
import org.cyclops.integratedterminalscompat.modcompat.rei.terminalstorage.TerminalStorageReiTransferHandler;

@REIPluginClient
public class ReiIntegratedTerminalsConfigClient
implements REIClientPlugin {
    private boolean loaded = false;
    private boolean wasReiVisible = false;

    public ReiIntegratedTerminalsConfigClient() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public void registerScreens(ScreenRegistry registry) {
        this.loaded = true;
        registry.registerFocusedStack((FocusedStackProvider)new TerminalStorageReiFocusedStackProvider());
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register((TransferHandler)new TerminalStorageReiTransferHandler());
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((ItemLike)PartTypes.TERMINAL_STORAGE.getItem())});
    }

    @SubscribeEvent
    public void onTerminalStorageButtons(TerminalStorageTabClientLoadButtonsEvent event) {
        if (this.loaded && !event.getButtons().stream().anyMatch(button -> button instanceof TerminalButtonItemStackCraftingGridSearchSync)) {
            event.getButtons().add(new TerminalButtonItemStackCraftingGridSearchSync("rei", event.getContainer().getGuiState(), event.getClientTab(), Images.BUTTON_MIDDLE_REI_SYNC));
        }
    }

    @SubscribeEvent
    public void onTerminalStorageScreenSize(TerminalStorageScreenSizeEvent event) {
        if (this.loaded) {
            try {
                boolean isOpen = REIRuntime.getInstance().getOverlay().isPresent();
                boolean wasJeiVisiblePrevious = this.wasReiVisible;
                if (isOpen) {
                    this.wasReiVisible = true;
                    event.setWidth(event.getWidth() - 170);
                } else {
                    this.wasReiVisible = false;
                }
                if (wasJeiVisiblePrevious != this.wasReiVisible) {
                    ((ContainerScreenTerminalStorage)Minecraft.getInstance().screen).init();
                }
            }
            catch (ClassCastException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onSearchFieldUpdated(TerminalStorageTabClientSearchFieldUpdateEvent event) {
        if (REIRuntime.getInstance().getOverlay().isPresent() && TerminalButtonItemStackCraftingGridSearchSync.isSearchSynced(event.getClientTab())) {
            REIRuntime.getInstance().getSearchTextField().setText(event.getSearchString());
        }
    }

    @SubscribeEvent
    public void onKeyTyped(ScreenEvent.KeyReleased.Post event) {
        if (event.getScreen() instanceof ContainerScreenTerminalStorage) {
            ContainerScreenTerminalStorage gui = (ContainerScreenTerminalStorage)event.getScreen();
            if (REIRuntime.getInstance().getOverlay().isPresent() && REIRuntime.getInstance().getSearchTextField().isFocused()) {
                gui.getSelectedClientTab().ifPresent(tab -> {
                    if (TerminalButtonItemStackCraftingGridSearchSync.isSearchSynced(tab)) {
                        WidgetTextFieldExtended fieldSearch = gui.getFieldSearch();
                        fieldSearch.setValue(REIRuntime.getInstance().getSearchTextField().getText());
                        tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)gui.getMenu()))).getSelectedChannel(), fieldSearch.getValue());
                    }
                });
            }
        }
    }
}

