/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import com.google.common.collect.Iterators;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SearchFieldEntry
extends AbstractConfigListEntry<Object> {
    private final EditBox editBox;
    private String[] lowerCases;

    public SearchFieldEntry(ConfigScreen screen, ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget) {
        super((Component)Component.empty(), false);
        this.editBox = new EditBox(Minecraft.getInstance().font, 0, 0, 100, 18, (Component)Component.empty());
        this.lowerCases = this.editBox.getValue().isEmpty() ? new String[]{} : this.editBox.getValue().toLowerCase(Locale.ROOT).split(" ");
        this.editBox.setResponder(s -> {
            this.lowerCases = s.isEmpty() ? new String[]{} : s.toLowerCase(Locale.ROOT).split(" ");
        });
        listWidget.entriesTransformer = entries -> new AbstractList<AbstractConfigEntry<AbstractConfigEntry<?>>>((List)entries, screen){
            final /* synthetic */ List val$entries;
            final /* synthetic */ ConfigScreen val$screen;
            {
                this.val$entries = list;
                this.val$screen = configScreen;
            }

            @Override
            public Iterator<AbstractConfigEntry<AbstractConfigEntry<?>>> iterator() {
                if (SearchFieldEntry.this.editBox.getValue().isEmpty()) {
                    return this.val$entries.iterator();
                }
                return Iterators.filter(this.val$entries.iterator(), entry -> entry.isDisplayed() && this.val$screen.matchesSearch(entry.getSearchTags()));
            }

            @Override
            public AbstractConfigEntry<AbstractConfigEntry<?>> get(int index) {
                return (AbstractConfigEntry)Iterators.get(this.iterator(), (int)index);
            }

            @Override
            public void add(int index, AbstractConfigEntry<AbstractConfigEntry<?>> element) {
                this.val$entries.add(index, element);
            }

            @Override
            public AbstractConfigEntry<AbstractConfigEntry<?>> remove(int index) {
                Object entry = this.get(index);
                return this.val$entries.remove(entry) ? entry : null;
            }

            @Override
            public boolean remove(Object o) {
                return this.val$entries.remove(o);
            }

            @Override
            public void clear() {
                this.val$entries.clear();
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }

    public boolean matchesSearch(Iterator<String> tags) {
        if (this.lowerCases.length == 0) {
            return true;
        }
        if (!tags.hasNext()) {
            return true;
        }
        for (String lowerCase : this.lowerCases) {
            boolean found = false;
            for (String tag : () -> tags) {
                if (!tag.toLowerCase(Locale.ROOT).contains(lowerCase)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        this.editBox.setWidth(Mth.clamp((int)(entryWidth - 10), (int)0, (int)500));
        this.editBox.setX(x + entryWidth / 2 - this.editBox.getWidth() / 2);
        this.editBox.setY(y + entryHeight / 2 - 9);
        this.editBox.render(graphics, mouseX, mouseY, delta);
        if (this.editBox.getValue().isEmpty()) {
            this.editBox.setSuggestion("Search...");
        } else {
            this.editBox.setSuggestion(null);
        }
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public Optional<Object> getDefaultValue() {
        return Optional.empty();
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return Collections.singletonList(this.editBox);
    }

    public List<? extends GuiEventListener> children() {
        return Collections.singletonList(this.editBox);
    }
}

