/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.client.util;

import com.google.common.base.Predicates;
import fuzs.magnumtorch.MagnumTorch;
import fuzs.magnumtorch.config.ServerConfig;
import fuzs.magnumtorch.world.level.block.MagnumTorchBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public class TorchTooltipHelper {
    public static List<Component> appendHoverText(MagnumTorchBlock block) {
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        tooltipLines.add((Component)Component.translatable((String)TooltipComponent.DESCRIPTION.getTranslationKey()).withStyle(ChatFormatting.GRAY));
        if (!Screen.hasShiftDown()) {
            tooltipLines.add((Component)Component.translatable((String)TooltipComponent.ADDITIONAL.getTranslationKey(), (Object[])new Object[]{Component.translatable((String)TooltipComponent.SHIFT.getTranslationKey()).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
        } else {
            for (TooltipComponent tooltipComponent : TooltipComponent.values()) {
                if (!tooltipComponent.notEmptyChecker.test(block.getType().getConfig())) continue;
                tooltipLines.add(tooltipComponent.getComponent(block.getType().getConfig()));
            }
        }
        return tooltipLines;
    }

    public static enum TooltipComponent implements StringRepresentable
    {
        DESCRIPTION,
        ADDITIONAL,
        SHIFT,
        MOB_TYPES(config -> !config.mobCategories.isEmpty(), config -> TooltipComponent.mergeComponentList(config.mobCategories, ChatFormatting.YELLOW, Enum::name)),
        BLACKLIST(config -> !config.mobBlacklist.isEmpty(), config -> TooltipComponent.mergeComponentList(config.mobBlacklist, ChatFormatting.AQUA, entityType -> BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString())),
        WHITELIST(config -> !config.mobWhitelist.isEmpty(), config -> TooltipComponent.mergeComponentList(config.mobWhitelist, ChatFormatting.AQUA, entityType -> BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString())),
        SHAPE_TYPE(config -> Component.literal((String)config.shapeType.name()).withStyle(ChatFormatting.GOLD)),
        HORIZONTAL_RANGE(config -> Component.literal((String)String.valueOf(config.horizontalRange)).withStyle(ChatFormatting.LIGHT_PURPLE)),
        VERTICAL_RANGE(config -> Component.literal((String)String.valueOf(config.verticalRange)).withStyle(ChatFormatting.LIGHT_PURPLE));

        final Predicate<ServerConfig.MagnumTorchConfig> notEmptyChecker;
        final Function<ServerConfig.MagnumTorchConfig, Component> componentFactory;

        private TooltipComponent() {
            this((Predicate<ServerConfig.MagnumTorchConfig>)Predicates.alwaysFalse(), config -> CommonComponents.EMPTY);
        }

        private TooltipComponent(Function<ServerConfig.MagnumTorchConfig, Component> componentFactory) {
            this((Predicate<ServerConfig.MagnumTorchConfig>)Predicates.alwaysTrue(), componentFactory);
        }

        private TooltipComponent(Predicate<ServerConfig.MagnumTorchConfig> notEmptyChecker, Function<ServerConfig.MagnumTorchConfig, Component> componentFactory) {
            this.notEmptyChecker = notEmptyChecker;
            this.componentFactory = componentFactory;
        }

        public String getTranslationKey() {
            return Util.makeDescriptionId((String)Registries.elementsDirPath((ResourceKey)Registries.BLOCK), (ResourceLocation)MagnumTorch.id("magnum_torch")) + ".tooltip." + this.getSerializedName();
        }

        public Component getComponent(ServerConfig.MagnumTorchConfig config) {
            Component component = this.componentFactory.apply(config);
            return Component.translatable((String)this.getTranslationKey(), (Object[])new Object[]{component}).withStyle(ChatFormatting.GRAY);
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private static <T> Component mergeComponentList(Collection<? extends T> collection, ChatFormatting format, Function<T, String> keyExtractor) {
            return (Component)collection.stream().map(mob -> Component.literal((String)((String)keyExtractor.apply(mob))).withStyle(format)).reduce((o1, o2) -> o1.append(", ").append((Component)o2)).orElse(Component.empty());
        }
    }
}

