/*
 * Decompiled with CFR 0.152.
 */
package fuzs.magnumtorch.handler;

import com.google.common.base.Predicates;
import fuzs.magnumtorch.MagnumTorch;
import fuzs.magnumtorch.config.ServerConfig;
import fuzs.magnumtorch.world.level.block.MagnumTorchType;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import org.jetbrains.annotations.NotNull;

public class MobSpawningHandler {
    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel, boolean isNewlySpawned) {
        Mob mob;
        block6: {
            block5: {
                if (!isNewlySpawned || !(entity instanceof Mob)) break block5;
                mob = (Mob)entity;
                if (MagnumTorch.CONFIG.getHolder(ServerConfig.class).isAvailable()) break block6;
            }
            return EventResult.PASS;
        }
        EntitySpawnReason entitySpawnReason = EntityHelper.getMobSpawnReason((Entity)mob);
        if (entitySpawnReason != null) {
            for (MagnumTorchType type : MagnumTorchType.values()) {
                if (!MobSpawningHandler.isSpawnCancelled(serverLevel.getPoiManager(), entity.getType(), entity.blockPosition(), entitySpawnReason, (ResourceKey<PoiType>)type.getPoiType().key(), type.getConfig())) continue;
                List<Entity> entities = entity.getRootVehicle().getSelfAndPassengers().distinct().filter(passenger -> passenger != entity).toList();
                serverLevel.getServer().schedule((Runnable)new TickTask(serverLevel.getServer().getTickCount(), () -> entities.forEach(Entity::discard)));
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    private static boolean isSpawnCancelled(PoiManager poiManager, EntityType<?> entityType, BlockPos toCheck, @NotNull EntitySpawnReason spawnType, ResourceKey<PoiType> poiTypeKey, ServerConfig.MagnumTorchConfig config) {
        if (config.blockedSpawnTypes.contains(spawnType) && config.isAffected(entityType)) {
            return poiManager.findAll(poiType -> poiType.is(poiTypeKey), (Predicate)Predicates.alwaysTrue(), toCheck, (int)Math.ceil((double)Math.max(config.horizontalRange, config.verticalRange) * 1.7320508076), PoiManager.Occupancy.ANY).anyMatch(pos -> config.shapeType.isPositionContained((BlockPos)pos, toCheck, config.horizontalRange, config.verticalRange));
        }
        return false;
    }
}

