/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectinsights.client.handler;

import fuzs.effectinsights.EffectInsights;
import fuzs.effectinsights.config.ClientConfig;
import fuzs.tooltipinsights.api.v1.client.handler.TooltipDescriptionsHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import org.jetbrains.annotations.Nullable;

public class FoodTooltipHandler {
    public static void onItemTooltip(ItemStack itemStack, List<Component> tooltipLines, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (!((ClientConfig)EffectInsights.CONFIG.get(ClientConfig.class)).effectItemTooltips.foodEffectTooltips) {
            return;
        }
        if (itemStack.has(DataComponents.CONSUMABLE)) {
            ArrayList<ApplyStatusEffectsConsumeEffect> consumeEffects = new ArrayList<ApplyStatusEffectsConsumeEffect>();
            for (ConsumeEffect consumeEffect : ((Consumable)itemStack.get(DataComponents.CONSUMABLE)).onConsumeEffects()) {
                if (!(consumeEffect instanceof ApplyStatusEffectsConsumeEffect)) continue;
                ApplyStatusEffectsConsumeEffect applyStatusEffectsConsumeEffect = (ApplyStatusEffectsConsumeEffect)consumeEffect;
                consumeEffects.add(applyStatusEffectsConsumeEffect);
            }
            if (!consumeEffects.isEmpty()) {
                Set<String> translationKeys = FoodTooltipHandler.getAllTranslationKeys(tooltipLines);
                ArrayList<Component> potionLines = new ArrayList<Component>();
                ArrayList<Component> attributeLines = new ArrayList<Component>();
                for (ApplyStatusEffectsConsumeEffect consumeEffect : consumeEffects) {
                    for (MobEffectInstance mobEffectInstance : consumeEffect.effects()) {
                        if (translationKeys.contains(mobEffectInstance.getDescriptionId())) continue;
                        FoodTooltipHandler.collectPotionTooltipLines(mobEffectInstance, tooltipContext.tickRate(), consumeEffect.probability(), potionLines, attributeLines);
                    }
                }
                FoodTooltipHandler.addPotionTooltipLines(tooltipLines, potionLines, attributeLines);
            }
        }
    }

    private static Set<String> getAllTranslationKeys(List<Component> tooltipLines) {
        return tooltipLines.stream().mapMulti((component, consumer) -> TooltipDescriptionsHandler.modifyTranslatableContents((Component)component, UnaryOperator.identity(), (translatableContents, contentsGatherer) -> {
            consumer.accept(translatableContents);
            return false;
        })).map(TranslatableContents::getKey).collect(Collectors.toSet());
    }

    private static void collectPotionTooltipLines(MobEffectInstance mobEffectInstance, float tickRate, float probability, List<Component> potionLines, List<Component> attributeLines) {
        ArrayList<MutableComponent> potionTooltip = new ArrayList<MutableComponent>();
        PotionContents.addPotionTooltip(Collections.singleton(mobEffectInstance), potionTooltip::add, (float)1.0f, (float)tickRate);
        if (!potionTooltip.isEmpty()) {
            int index;
            if (probability != 1.0f) {
                String s = Mth.floor((float)(probability * 100.0f)) + "%";
                potionTooltip.set(0, Component.translatable((String)"potion.withDuration", (Object[])new Object[]{potionTooltip.getFirst(), s}).withStyle(ChatFormatting.GOLD));
            }
            if ((index = potionTooltip.indexOf(CommonComponents.EMPTY)) != -1) {
                potionLines.addAll(potionTooltip.subList(0, index));
                attributeLines.addAll(potionTooltip.subList(index + 1, potionTooltip.size()));
            } else {
                potionLines.addAll(potionTooltip);
            }
        }
    }

    private static void addPotionTooltipLines(List<Component> tooltipLines, List<Component> potionLines, List<Component> attributeLines) {
        if (tooltipLines.isEmpty()) {
            tooltipLines.addAll(potionLines);
            if (!attributeLines.isEmpty()) {
                tooltipLines.add(CommonComponents.EMPTY);
                tooltipLines.addAll(attributeLines);
            }
        } else {
            if (!attributeLines.isEmpty()) {
                tooltipLines.addAll(1, attributeLines);
                tooltipLines.add(1, CommonComponents.EMPTY);
            }
            tooltipLines.addAll(1, potionLines);
        }
    }
}

