/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.lucko.spark.common.util.ThreadFinder;
import me.lucko.spark.proto.SparkSamplerProtos;

public interface ThreadDumper {
    public static final ThreadDumper ALL = new ThreadDumper(){

        @Override
        public ThreadInfo[] dumpThreads(ThreadMXBean threadBean) {
            return threadBean.dumpAllThreads(false, false);
        }

        @Override
        public boolean isThreadIncluded(long threadId, String threadName) {
            return true;
        }

        @Override
        public SparkSamplerProtos.SamplerMetadata.ThreadDumper getMetadata() {
            return (SparkSamplerProtos.SamplerMetadata.ThreadDumper)SparkSamplerProtos.SamplerMetadata.ThreadDumper.newBuilder().setType(SparkSamplerProtos.SamplerMetadata.ThreadDumper.Type.ALL).build();
        }
    };

    public ThreadInfo[] dumpThreads(ThreadMXBean var1);

    public boolean isThreadIncluded(long var1, String var3);

    public SparkSamplerProtos.SamplerMetadata.ThreadDumper getMetadata();

    public static ThreadDumper parseConfigSetting(String setting) {
        switch (setting) {
            case "default": {
                return null;
            }
            case "all": {
                return ALL;
            }
        }
        Set<String> threadNames = Arrays.stream(setting.split(",")).collect(Collectors.toSet());
        return new Specific(threadNames);
    }

    public static final class Specific
    implements ThreadDumper {
        private final long[] ids;
        private Set<Thread> threads;
        private Set<String> threadNamesLowerCase;

        public Specific(Thread thread) {
            this.ids = new long[]{thread.getId()};
        }

        public Specific(Set<String> names) {
            this.threadNamesLowerCase = names.stream().map(String::toLowerCase).collect(Collectors.toSet());
            this.ids = new ThreadFinder().getThreads().filter(t -> this.threadNamesLowerCase.contains(t.getName().toLowerCase())).mapToLong(Thread::getId).toArray();
            Arrays.sort(this.ids);
        }

        public Set<Thread> getThreads() {
            if (this.threads == null) {
                this.threads = new ThreadFinder().getThreads().filter(t -> Arrays.binarySearch(this.ids, t.getId()) >= 0).collect(Collectors.toSet());
            }
            return this.threads;
        }

        public Set<String> getThreadNames() {
            if (this.threadNamesLowerCase == null) {
                this.threadNamesLowerCase = this.getThreads().stream().map(t -> t.getName().toLowerCase()).collect(Collectors.toSet());
            }
            return this.threadNamesLowerCase;
        }

        @Override
        public boolean isThreadIncluded(long threadId, String threadName) {
            if (Arrays.binarySearch(this.ids, threadId) >= 0) {
                return true;
            }
            return this.getThreadNames().contains(threadName.toLowerCase());
        }

        @Override
        public ThreadInfo[] dumpThreads(ThreadMXBean threadBean) {
            return threadBean.getThreadInfo(this.ids, Integer.MAX_VALUE);
        }

        @Override
        public SparkSamplerProtos.SamplerMetadata.ThreadDumper getMetadata() {
            return (SparkSamplerProtos.SamplerMetadata.ThreadDumper)SparkSamplerProtos.SamplerMetadata.ThreadDumper.newBuilder().setType(SparkSamplerProtos.SamplerMetadata.ThreadDumper.Type.SPECIFIC).addAllIds(Arrays.stream(this.ids).boxed().collect(Collectors.toList())).build();
        }
    }

    public static final class Regex
    implements ThreadDumper {
        private final ThreadFinder threadFinder = new ThreadFinder();
        private final Set<Pattern> namePatterns;
        private final Map<Long, Boolean> cache = new HashMap<Long, Boolean>();

        public Regex(Set<String> namePatterns) {
            this.namePatterns = namePatterns.stream().map(regex -> Pattern.compile(regex, 2)).collect(Collectors.toSet());
        }

        @Override
        public boolean isThreadIncluded(long threadId, String threadName) {
            Boolean result = this.cache.get(threadId);
            if (result != null) {
                return result;
            }
            for (Pattern pattern : this.namePatterns) {
                if (!pattern.matcher(threadName).matches()) continue;
                this.cache.put(threadId, true);
                return true;
            }
            this.cache.put(threadId, false);
            return false;
        }

        @Override
        public ThreadInfo[] dumpThreads(ThreadMXBean threadBean) {
            return (ThreadInfo[])this.threadFinder.getThreads().filter(thread -> this.isThreadIncluded(thread.getId(), thread.getName())).map(thread -> threadBean.getThreadInfo(thread.getId(), Integer.MAX_VALUE)).filter(Objects::nonNull).toArray(ThreadInfo[]::new);
        }

        @Override
        public SparkSamplerProtos.SamplerMetadata.ThreadDumper getMetadata() {
            return (SparkSamplerProtos.SamplerMetadata.ThreadDumper)SparkSamplerProtos.SamplerMetadata.ThreadDumper.newBuilder().setType(SparkSamplerProtos.SamplerMetadata.ThreadDumper.Type.REGEX).addAllPatterns(this.namePatterns.stream().map(Pattern::pattern).collect(Collectors.toList())).build();
        }
    }

    public static final class GameThread
    implements Supplier<ThreadDumper> {
        private Supplier<Thread> threadSupplier;
        private Specific dumper = null;

        public GameThread() {
        }

        public GameThread(Supplier<Thread> threadSupplier) {
            this.threadSupplier = threadSupplier;
        }

        @Override
        public ThreadDumper get() {
            if (this.dumper == null) {
                this.setThread(this.threadSupplier.get());
                this.threadSupplier = null;
            }
            return Objects.requireNonNull(this.dumper, "dumper");
        }

        public void setThread(Thread thread) {
            this.dumper = new Specific(thread);
        }
    }
}

