/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.inventory;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.CreativeCoreGuiRegistry;
import team.creative.creativecore.client.gui.control.inventory.GuiClientSlotBase;
import team.creative.creativecore.client.gui.manager.GuiClientManagerItem;
import team.creative.creativecore.common.gui.control.inventory.GuiSlot;
import team.creative.creativecore.common.gui.control.inventory.IGuiInventory;

public class GuiClientSlot<T extends GuiSlot>
extends GuiClientSlotBase<T>
implements GuiSlot.GuiSlotDist {
    public int draggedIndex = -1;

    public GuiClientSlot(T control) {
        super(control);
    }

    public GuiClientManagerItem itemManager() {
        return (GuiClientManagerItem)((Object)((GuiSlot)this.control).itemManager().dist);
    }

    public IGuiInventory inventory() {
        return ((GuiSlot)this.control).inventory();
    }

    @Override
    public void changed() {
        if (this.draggedIndex != -1) {
            this.itemManager().modifyDrag(this);
        }
    }

    @Override
    protected ItemStack getStackToRender() {
        if (this.draggedIndex != -1) {
            ItemStack stack = this.itemManager().getHand().copy();
            int toAdd = Math.min(this.itemManager().additionalDragCount(this.draggedIndex), ((GuiSlot)this.control).slot.getMaxStackSize(stack) - ((GuiSlot)this.control).slot.getItem().getCount());
            stack.setCount(toAdd + ((GuiSlot)this.control).slot.getItem().getCount());
            return stack;
        }
        return ((GuiSlot)this.control).getStack();
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.getInstance().options.keyDrop.matches(keyCode, scanCode) && this.isHovered()) {
            CreativeCoreGuiRegistry.DROP.sendAndExecute((GuiSlot)this.control, ByteTag.valueOf((boolean)Screen.hasControlDown()));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseScrolled(double x, double y, double delta) {
        if (!Screen.hasShiftDown()) {
            return false;
        }
        if (delta > 0.0) {
            CreativeCoreGuiRegistry.INSERT.sendAndExecute((GuiSlot)this.control, IntTag.valueOf((int)((int)delta)));
        } else {
            CreativeCoreGuiRegistry.EXTRACT.sendAndExecute((GuiSlot)this.control, IntTag.valueOf((int)((int)(-delta))));
        }
        return true;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (this.itemManager().isDragged()) {
            return true;
        }
        if (Screen.hasShiftDown()) {
            if (((GuiSlot)this.control).slot.mayPickup(((GuiSlot)this.control).getPlayer())) {
                CreativeCoreGuiRegistry.INSERT.sendAndExecute((GuiSlot)this.control, IntTag.valueOf((int)((GuiSlot)this.control).slot.getMaxStackSize()));
            }
            return true;
        }
        ItemStack hand = this.itemManager().getHand();
        if (!hand.isEmpty() && button < 2) {
            int stackSize = GuiClientManagerItem.freeSpace(((GuiSlot)this.control).slot, hand);
            if (stackSize > 0) {
                this.itemManager().startDrag(this, button == 1, stackSize);
            }
            if (stackSize != -1) {
                return true;
            }
        }
        if (button == 2) {
            CreativeCoreGuiRegistry.DUPLICATE.sendAndExecute((GuiSlot)this.control, EndTag.INSTANCE);
        } else if (((GuiSlot)this.control).slot.mayPickup(((GuiSlot)this.control).getPlayer()) && (hand.isEmpty() || ((GuiSlot)this.control).slot.mayPlace(hand))) {
            CreativeCoreGuiRegistry.SWAP.sendAndExecute((GuiSlot)this.control, ByteTag.valueOf((button == 1 ? 1 : 0) != 0));
        }
        return true;
    }

    @Override
    public void mouseMoved(double x, double y) {
        if (this.draggedIndex == -1 && this.itemManager().isDragged() && this.rect.inside(x + (double)this.rect.getX(), y + (double)this.rect.getY())) {
            this.itemManager().addToDrag(this);
        }
    }

    public Slot slot() {
        return ((GuiSlot)this.control).slot;
    }
}

