/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.parent;

import java.util.List;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiClientParent;
import team.creative.creativecore.client.gui.GuiControlRect;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiTabs;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiClientTabs<T extends GuiTabs>
extends GuiClientParent<T>
implements GuiTabs.GuiTabsDist {
    private List<GuiTabs.GuiTabSpecialParent> tabs;
    private GuiTabs.GuiTabBar bar;
    private int index = -1;
    private GuiParent selected;
    private int lastWidth;
    private int lastHeight = -1;
    private int lastY;

    public GuiClientTabs(T control) {
        super(control);
    }

    @Override
    public void init(List<GuiTabs.GuiTabSpecialParent> tabs, GuiTabs.GuiTabBar bar) {
        this.tabs = tabs;
        this.bar = bar;
    }

    @Override
    public void flowX(int width, int preferred) {
        super.flowX(width, preferred);
        this.lastWidth = width;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        super.flowY(width, height, preferred);
        if (this.selected != null) {
            this.lastHeight = ((GuiClientControl)((Object)this.selected.dist())).rect.getHeight();
            this.lastY = ((GuiClientControl)((Object)this.selected.dist())).rect.getY();
        } else {
            this.lastHeight = -1;
        }
    }

    @Override
    protected ControlFormatting defaultFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    @Override
    public void select(int select, boolean notify) {
        if (this.selected != null) {
            ((GuiTabs)this.control).remove(this.selected);
        }
        this.index = select;
        this.selected = this.tabs.get(select);
        this.bar.highlight(select);
        ((GuiTabs)this.control).add((GuiControl)this.selected);
        if (this.lastHeight == -1 && this.getParent() != null) {
            ((GuiTabs)this.control).reflow();
        } else {
            GuiControlRect rect = ((GuiClientControl)((Object)this.selected.dist())).rect;
            rect.setX(0);
            rect.setWidth(this.lastWidth, this.lastWidth);
            rect.flowX();
            rect.setY(this.lastY);
            rect.setHeight(this.lastHeight, this.lastHeight);
            rect.flowY();
        }
        if (notify) {
            this.raiseEvent(new GuiControlChangedEvent<GuiControl>(this.control));
        }
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public GuiParent.GuiParentDistHandler createSpecialParent(GuiTabs.GuiTabSpecialParent parent) {
        return new GuiClientTabSpecialParent(parent);
    }

    private class GuiClientTabSpecialParent
    extends GuiClientParent<GuiTabs.GuiTabSpecialParent> {
        public GuiClientTabSpecialParent(GuiTabs.GuiTabSpecialParent control) {
            super(control);
        }

        @Override
        public ControlFormatting getControlFormatting() {
            return ControlFormatting.NESTED;
        }

        @Override
        protected int preferredWidth(int availableWidth) {
            int pref = 0;
            for (GuiTabs.GuiTabSpecialParent p : GuiClientTabs.this.tabs) {
                pref = Math.max(pref, ((GuiClientTabSpecialParent)p.dist()).preferredWidthOriginal(availableWidth));
            }
            return pref;
        }

        protected int preferredWidthOriginal(int availableWidth) {
            return super.preferredWidth(availableWidth);
        }

        @Override
        protected int preferredHeight(int width, int availableHeight) {
            int pref = 0;
            for (GuiTabs.GuiTabSpecialParent p : GuiClientTabs.this.tabs) {
                pref = Math.max(pref, ((GuiClientTabSpecialParent)p.dist()).preferredHeightOriginal(width, availableHeight));
            }
            return pref;
        }

        protected int preferredHeightOriginal(int width, int availableHeight) {
            return super.preferredHeight(width, availableHeight);
        }
    }
}

