/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.tree;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix3x2fStack;
import team.creative.creativecore.client.gui.GuiClientControl;
import team.creative.creativecore.client.gui.GuiControlRect;
import team.creative.creativecore.client.gui.control.parent.GuiClientScrollXY;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.control.tree.GuiTree;
import team.creative.creativecore.common.gui.control.tree.GuiTreeDragPosition;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.ColorUtils;

public class GuiClientTree<T extends GuiTree>
extends GuiClientScrollXY<T>
implements GuiTree.GuiTreeDist {
    private static final int LEVEL_SPACING = 10;
    protected StyleDisplay line = new DisplayColor(-1);
    protected StyleDisplay dragLine = new DisplayColor(-16777216);
    protected StyleDisplay dragHover = new DisplayColor(ColorUtils.rgb(200, 150, 0));
    private int lastWidth;
    private int lastHeight;
    private int lineThickness;
    private int halfLineThickness;
    private GuiTreeItem dragged = null;
    private GuiTreeDragPosition lastDragPosition = null;

    public GuiClientTree(T control) {
        super(control);
    }

    @Override
    public void reflowTree() {
        if (this.lastWidth != 0) {
            this.flowX(this.lastWidth, this.preferredWidth(this.lastWidth));
            this.flowY(this.lastWidth, this.lastHeight, this.preferredHeight(this.lastWidth, this.lastHeight));
        }
    }

    @Override
    public void setLineThickness(int thickness) {
        this.lineThickness = thickness;
        this.halfLineThickness = thickness / 2;
    }

    protected int offsetByLevel(int level) {
        if (((GuiTree)this.control).isRootVisible()) {
            return 10 * level;
        }
        return 10 * (level - 1);
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        int width = 0;
        for (GuiClientControl control : this.controls()) {
            Object t = control.control;
            if (t instanceof GuiTreeItem) {
                GuiTreeItem item = (GuiTreeItem)t;
                width = Math.max(width, this.offsetByLevel(item.getLevel()) + 1 + control.rect.getPreferredWidth(availableWidth));
                continue;
            }
            width = Math.max(width, control.rect.getPreferredWidth(availableWidth));
        }
        return width;
    }

    @Override
    public void flowX(int width, int preferred) {
        super.flowX(width, preferred);
        for (GuiClientControl control : this.controls()) {
            Object t = control.control;
            if (!(t instanceof GuiTreeItem)) continue;
            GuiTreeItem item = (GuiTreeItem)t;
            control.rect.setX(this.offsetByLevel(item.getLevel()) + 1);
        }
        this.updateWidth();
        this.lastWidth = width;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        super.flowY(width, height, preferred);
        this.lastHeight = height;
    }

    @Override
    protected void renderContent(GuiGraphics graphics, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        Matrix3x2fStack pose = graphics.pose();
        if (((GuiTree)this.control).isDragged()) {
            pose.pushMatrix();
            pose.translate((float)((double)this.getContentOffset() + this.getOffsetX()), (float)((double)this.getContentOffset() + this.getOffsetY()));
            this.lastDragPosition = this.calculatePosition((int)((double)mouseX - realRect.minX - (double)this.getContentOffset()), (int)((double)mouseY - realRect.minY - (double)this.getContentOffset()));
            if (this.lastDragPosition != null) {
                GuiControlRect rect = ((GuiClientControl)((Object)this.lastDragPosition.item().dist())).rect;
                if (this.lastDragPosition.position() == GuiTreeDragPosition.ItemPosition.IN) {
                    this.dragHover.render(graphics, rect);
                } else {
                    int minY;
                    int thickness = 1;
                    int width = rect.getWidth();
                    if (this.lastDragPosition.position() == GuiTreeDragPosition.ItemPosition.ABOVE) {
                        minY = rect.getY() - thickness - 1;
                        if (this.lastDragPosition.above() != null) {
                            width = Math.max(width, rect.getWidth());
                        }
                    } else {
                        minY = rect.getBottom() + 1;
                    }
                    if (this.lastDragPosition.above() != null) {
                        this.dragLine.render(graphics, rect.getX() - thickness, minY - thickness, thickness, thickness * 3);
                        this.dragLine.render(graphics, rect.getX() + width, minY - thickness, thickness, thickness * 3);
                    } else if (this.lastDragPosition.position() == GuiTreeDragPosition.ItemPosition.ABOVE) {
                        this.dragLine.render(graphics, rect.getX() - thickness, minY, thickness, thickness * 2);
                        this.dragLine.render(graphics, rect.getX() + width, minY, thickness, thickness * 2);
                    } else {
                        this.dragLine.render(graphics, rect.getX() - thickness, minY - thickness, thickness, thickness * 2);
                        this.dragLine.render(graphics, rect.getX() + width, minY - thickness, thickness, thickness * 2);
                    }
                    this.dragLine.render(graphics, rect.getX(), minY, width, thickness);
                }
            }
            pose.popMatrix();
        } else {
            this.lastDragPosition = null;
        }
        super.renderContent(graphics, formatting, borderWidth, controlRect, realRect, scale, mouseX, mouseY);
        pose.pushMatrix();
        pose.translate((float)this.getOffsetX(), (float)((double)this.getContentOffset() + this.getOffsetY()));
        ArrayList<GuiTreeLine> lines = new ArrayList<GuiTreeLine>();
        int size = -1;
        for (GuiClientControl control : this.controls()) {
            Object t = control.control;
            if (!(t instanceof GuiTreeItem)) continue;
            GuiTreeItem item = (GuiTreeItem)t;
            int lineY = (control.rect.getY() + control.rect.getBottom()) / 2 + this.halfLineThickness;
            int level = item.getLevel() - (((GuiTree)this.control).isRootVisible() ? 1 : 2);
            if (level <= size) {
                if (level >= 0) {
                    ((GuiTreeLine)lines.get((int)level)).y2 = lineY;
                }
                for (int i = size; i > level; --i) {
                    if (((GuiTreeLine)lines.get((int)i)).invalid) continue;
                    ((GuiTreeLine)lines.get(i)).render(graphics);
                    ((GuiTreeLine)lines.get((int)i)).invalid = false;
                }
                size = level;
            } else {
                if (level < 0) continue;
                while (level > size) {
                    if (lines.size() > size + 1) {
                        ((GuiTreeLine)lines.get(level)).set(control.rect.getY() - 2, lineY);
                    } else {
                        lines.add(new GuiTreeLine(size + 1, control.rect.getY() - 2, lineY));
                    }
                    ++size;
                }
            }
            if (level < 0) continue;
            this.line.render(graphics, ((GuiTreeLine)lines.get((int)level)).x + this.lineThickness, lineY - this.lineThickness, 5.0, this.lineThickness);
        }
        if (size >= 0) {
            for (int i = size; i > -1; --i) {
                if (((GuiTreeLine)lines.get((int)i)).invalid) continue;
                ((GuiTreeLine)lines.get(i)).render(graphics);
                ((GuiTreeLine)lines.get((int)i)).invalid = false;
            }
        }
        pose.popMatrix();
    }

    private GuiTreeDragPosition createPosition(GuiTreeDragPosition.ItemPosition position, GuiTreeItem item, GuiControl before) {
        GuiTreeItem item2;
        if (item == ((GuiTree)this.control).root() && position != GuiTreeDragPosition.ItemPosition.IN) {
            return null;
        }
        return new GuiTreeDragPosition(position, item, before != null && before instanceof GuiTreeItem && (item2 = (GuiTreeItem)before).getLevel() == item.getLevel() ? before : null);
    }

    protected GuiTreeDragPosition calculatePosition(int mouseX, int mouseY) {
        Object last = null;
        GuiControl before = null;
        for (GuiClientControl control : this.controls()) {
            if (control.control == this.dragged) continue;
            Object t = control.control;
            if (t instanceof GuiTreeItem) {
                GuiTreeItem item = (GuiTreeItem)t;
                if (control.rect.getY() > mouseY) {
                    return this.createPosition(GuiTreeDragPosition.ItemPosition.ABOVE, item, before);
                }
                if (control.rect.inside(mouseX, mouseY)) {
                    return this.createPosition(GuiTreeDragPosition.ItemPosition.IN, item, before);
                }
                last = control.control;
            }
            before = (GuiControl)control.control;
        }
        if (last != null) {
            return this.createPosition(GuiTreeDragPosition.ItemPosition.BELOW, last, null);
        }
        return null;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (super.mouseClicked(x, y, button)) {
            return true;
        }
        if (((GuiTree)this.control).canDeselect()) {
            ((GuiTree)this.control).select(null);
        }
        return true;
    }

    @Override
    public boolean isDragged() {
        return this.dragged != null;
    }

    @Override
    public void startDrag(GuiTreeItem item) {
        this.dragged = item;
    }

    @Override
    public boolean endDrag() {
        ((GuiTree)this.control).performModication(this.dragged, this.lastDragPosition);
        this.lastDragPosition = null;
        this.dragged = null;
        return true;
    }

    private class GuiTreeLine {
        public final int x;
        public int y;
        public int y2;
        public boolean invalid;

        public GuiTreeLine(int level, int minY, int maxY) {
            this.x = GuiClientTree.this.offsetByLevel(level + (((GuiTree)GuiClientTree.this.control).isRootVisible() ? 1 : 2)) - 5;
            this.set(minY, maxY);
        }

        public void set(int minY, int maxY) {
            this.y = minY;
            this.y2 = maxY;
            this.invalid = false;
        }

        public void render(GuiGraphics graphics) {
            GuiClientTree.this.line.render(graphics, this.x, this.y, GuiClientTree.this.lineThickness, this.y2 - this.y);
        }
    }
}

