/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.integration;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import team.creative.creativecore.client.gui.GuiClientLayer;
import team.creative.creativecore.client.gui.IGuiClientIntegratedParent;
import team.creative.creativecore.client.gui.integration.ScreenEventListener;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiControlDistHandler;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IScaleableGuiScreen;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.gui.manager.GuiManagerDist;
import team.creative.creativecore.common.network.CreativePacket;

public class ContainerScreenIntegration
extends AbstractContainerScreen<ContainerIntegration>
implements IScaleableGuiScreen,
IGuiClientIntegratedParent {
    protected ScreenEventListener listener = new ScreenEventListener((IGuiIntegratedParent)this.getMenu(), (Screen)this);

    public ContainerScreenIntegration(ContainerIntegration screenContainer, Inventory inv) {
        super((AbstractContainerMenu)screenContainer, inv, (Component)Component.literal((String)"gui-api"));
        screenContainer.setScreen(this);
    }

    protected void init() {
        this.addWidget(this.listener);
    }

    protected void rebuildWidgets() {
        super.rebuildWidgets();
        for (GuiLayer layer : ((ContainerIntegration)this.getMenu()).getLayers()) {
            layer.reflow();
        }
    }

    public boolean mouseDragged(double x, double y, int button, double dragX, double dragY) {
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(x, y, button, dragX, dragY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        IGuiClientIntegratedParent.render((IGuiIntegratedParent)this.getMenu(), graphics, (Screen)this, this.listener, mouseX, mouseY);
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (GuiLayer layer : ((ContainerIntegration)this.getMenu()).getLayers()) {
            GuiClientLayer c = (GuiClientLayer)layer.dist();
            int offsetX = (this.width - c.getWidth()) / 2;
            int offsetY = (this.height - c.getHeight()) / 2;
            minX = Math.min(minX, offsetX + c.rect.getX());
            minY = Math.min(minY, offsetY + c.rect.getY());
            maxX = Math.max(maxX, offsetX + c.rect.getRight());
            maxY = Math.max(maxY, offsetY + c.rect.getBottom());
        }
        this.leftPos = minX;
        this.topPos = minY;
        this.imageWidth = maxX - minX;
        this.imageHeight = maxY - minY;
    }

    @Override
    public void clientTick() {
        for (GuiLayer layer : ((ContainerIntegration)this.getMenu()).getLayers()) {
            layer.tick();
        }
    }

    @Override
    public int getWidth() {
        int width = 0;
        for (GuiLayer layer : ((ContainerIntegration)this.getMenu()).getLayers()) {
            width = Math.max(width, ((GuiClientLayer)layer.dist()).getWidth());
        }
        return width;
    }

    @Override
    public int getHeight() {
        int height = 0;
        for (GuiLayer layer : ((ContainerIntegration)this.getMenu()).getLayers()) {
            height = Math.max(height, ((GuiClientLayer)layer.dist()).getHeight());
        }
        return height;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
    }

    public void mouseMoved(double x, double y) {
        this.listener.mouseMoved(x, y);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.listener.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.listener.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.listener.charTyped(codePoint, modifiers)) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    @Override
    public HolderLookup.Provider provider() {
        return ((ContainerIntegration)this.menu).provider();
    }

    @Override
    public List<GuiLayer> getLayers() {
        return ((ContainerIntegration)this.menu).getLayers();
    }

    @Override
    public GuiLayer getTopLayer() {
        return ((ContainerIntegration)this.menu).getTopLayer();
    }

    @Override
    public void openLayer(GuiLayer layer) {
        ((ContainerIntegration)this.menu).openLayer(layer);
    }

    @Override
    public void closeLayer(int layer) {
        ((ContainerIntegration)this.menu).closeLayer(layer);
    }

    @Override
    public void send(CreativePacket message) {
        ((ContainerIntegration)this.menu).send(message);
    }

    @Override
    public boolean isContainer() {
        return ((ContainerIntegration)this.menu).isContainer();
    }

    @Override
    public boolean isClient() {
        return ((ContainerIntegration)this.menu).isClient();
    }

    @Override
    public Player getPlayer() {
        return ((ContainerIntegration)this.menu).getPlayer();
    }

    @Override
    public void closeTopLayer() {
        ((ContainerIntegration)this.menu).closeTopLayer();
    }

    @Override
    public void closeLayer(GuiLayer layer) {
        ((ContainerIntegration)this.menu).closeLayer(layer);
    }

    @Override
    public GuiControlDistHandler createDist(GuiControl control) {
        return ((ContainerIntegration)this.menu).createDist(control);
    }

    @Override
    public <T extends GuiManagerDist> T createDist(GuiManager<T> manager) {
        return ((ContainerIntegration)this.menu).createDist(manager);
    }
}

