/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.matrix;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public interface IVecOrigin {
    public double offX();

    public double offY();

    public double offZ();

    public double rotX();

    public double rotY();

    public double rotZ();

    public double offXLast();

    public double offYLast();

    public double offZLast();

    public double rotXLast();

    public double rotYLast();

    public double rotZLast();

    public boolean isRotated();

    public void offX(double var1);

    public void offY(double var1);

    public void offZ(double var1);

    public void off(double var1, double var3, double var5);

    public void rotX(double var1);

    public void rotY(double var1);

    public void rotZ(double var1);

    public void rot(double var1, double var3, double var5);

    public Vec3d center();

    public void setCenter(Vec3d var1);

    public Matrix3 rotation();

    public Matrix3 rotationInv();

    public Vec3d translation();

    public void tick();

    public IVecOrigin getParent();

    default public void set(IVecOrigin origin) {
        this.off(origin.offXLast(), origin.offYLast(), origin.offZLast());
        this.rot(origin.rotXLast(), origin.rotYLast(), origin.rotZLast());
        this.tick();
        this.off(origin.offX(), origin.offY(), origin.offZ());
        this.rot(origin.rotX(), origin.rotY(), origin.rotZ());
    }

    default public double translationCombined(Axis axis) {
        return this.translation().get(axis);
    }

    default public void onlyRotateWithoutCenter(Vec3d vec) {
        this.rotation().transform(vec);
    }

    default public BlockPos transformPointToWorld(BlockPos pos) {
        Vec3d vec = new Vec3d((Vec3i)pos);
        this.transformPointToWorld(vec);
        return vec.toBlockPos();
    }

    default public BlockPos transformPointToFakeWorld(BlockPos pos) {
        Vec3d vec = new Vec3d((Vec3i)pos);
        this.transformPointToFakeWorld(vec);
        return vec.toBlockPos();
    }

    default public void transformPointToWorld(Vec3d vec) {
        vec.sub(this.center());
        this.rotation().transform(vec);
        vec.add(this.center());
        vec.add(this.translation());
    }

    default public void transformPointToFakeWorld(Vec3d vec) {
        vec.sub(this.translation());
        vec.sub(this.center());
        this.rotationInv().transform(vec);
        vec.add(this.center());
    }

    default public Vector3d transformPointToWorld(Vector3d vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToWorld(real);
        return new Vector3d(real.x, real.y, real.z);
    }

    default public Vector3d transformPointToFakeWorld(Vector3d vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToFakeWorld(real);
        return new Vector3d(real.x, real.y, real.z);
    }

    default public Vec3 transformPointToWorld(Vec3 vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToWorld(real);
        return new Vec3(real.x, real.y, real.z);
    }

    default public Vec3 transformPointToFakeWorld(Vec3 vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToFakeWorld(real);
        return new Vec3(real.x, real.y, real.z);
    }

    default public ABB getAABB(AABB box) {
        ABB bb = ABB.createEmptyBox();
        Vec3d vec = new Vec3d();
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner.values()[i].set(box, vec);
            this.transformPointToWorld(vec);
            bb.minX = Math.min(bb.minX, vec.x);
            bb.minY = Math.min(bb.minY, vec.y);
            bb.minZ = Math.min(bb.minZ, vec.z);
            bb.maxX = Math.max(bb.maxX, vec.x);
            bb.maxY = Math.max(bb.maxY, vec.y);
            bb.maxZ = Math.max(bb.maxZ, vec.z);
        }
        return bb;
    }

    default public ABB getOBB(AABB box) {
        ABB bb = ABB.createEmptyBox();
        Vec3d vec = new Vec3d();
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner.values()[i].set(box, vec);
            this.transformPointToFakeWorld(vec);
            bb.minX = Math.min(bb.minX, vec.x);
            bb.minY = Math.min(bb.minY, vec.y);
            bb.minZ = Math.min(bb.minZ, vec.z);
            bb.maxX = Math.max(bb.maxX, vec.x);
            bb.maxY = Math.max(bb.maxY, vec.y);
            bb.maxZ = Math.max(bb.maxZ, vec.z);
        }
        return bb;
    }

    default public ABB getAABB(ABB box) {
        ABB bb = ABB.createEmptyBox();
        Vec3d vec = new Vec3d();
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner.values()[i].set(box, vec);
            this.transformPointToWorld(vec);
            bb.minX = Math.min(bb.minX, vec.x);
            bb.minY = Math.min(bb.minY, vec.y);
            bb.minZ = Math.min(bb.minZ, vec.z);
            bb.maxX = Math.max(bb.maxX, vec.x);
            bb.maxY = Math.max(bb.maxY, vec.y);
            bb.maxZ = Math.max(bb.maxZ, vec.z);
        }
        return bb;
    }

    default public ABB getOBB(ABB box) {
        ABB bb = ABB.createEmptyBox();
        Vec3d vec = new Vec3d();
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner.values()[i].set(box, vec);
            this.transformPointToFakeWorld(vec);
            bb.minX = Math.min(bb.minX, vec.x);
            bb.minY = Math.min(bb.minY, vec.y);
            bb.minZ = Math.min(bb.minZ, vec.z);
            bb.maxX = Math.max(bb.maxX, vec.x);
            bb.maxY = Math.max(bb.maxY, vec.y);
            bb.maxZ = Math.max(bb.maxZ, vec.z);
        }
        return bb;
    }

    default public boolean hasChanged() {
        return this.offXLast() != this.offX() || this.offYLast() != this.offY() || this.offZLast() != this.offZ() || this.rotXLast() != this.rotX() || this.rotYLast() != this.rotY() || this.rotZLast() != this.rotZ();
    }

    public IVecOrigin copy();
}

