/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.client.render.ItemInStorageHighlightRenderer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class ClientEventHandler {
    private static final int MIDDLE_BUTTON = 2;
    private static final String KEYBIND_SOPHISTICATEDCORE_CATEGORY = "keybind.sophisticatedcore.category";
    public static final KeyMapping ITEM_HIGHLIGHT_KEYBIND = new KeyMapping(TranslationHelper.INSTANCE.translKeybind("item_highlight"), (IKeyConflictContext)ItemHighlightKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.getOrCreate(59), "keybind.sophisticatedcore.category");
    public static final KeyMapping SORT_KEYBIND = new KeyMapping(TranslationHelper.INSTANCE.translKeybind("sort"), (IKeyConflictContext)SophisticatedScreenKeyConflictContext.INSTANCE, InputConstants.Type.MOUSE.getOrCreate(2), "keybind.sophisticatedcore.category");

    private ClientEventHandler() {
    }

    public static void registerHandlers(IEventBus modBus) {
        modBus.addListener(ModParticles::registerFactories);
        modBus.addListener(ClientEventHandler::registerFluidClientExtension);
        modBus.addListener(ClientEventHandler::registerKeyMappings);
        modBus.addListener(ClientEventHandler::registerRenderPipelines);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(StorageSoundHandler::tick);
        eventBus.addListener(StorageSoundHandler::onWorldUnload);
        eventBus.addListener(ClientEventHandler::onDrawScreen);
        eventBus.addListener(ClientEventHandler::recipesReceived);
        eventBus.addListener(ClientEventHandler::handleGuiKeyPress);
        eventBus.addListener(ClientEventHandler::handleGuiMouseKeyPress);
        eventBus.addListener(ClientEventHandler::handleKeyInput);
        eventBus.addListener(ClientEventHandler::renderLevelStage);
    }

    private static void renderLevelStage(RenderLevelStageEvent.AfterBlockEntities event) {
        ItemInStorageHighlightRenderer.render(event.getPoseStack(), event.getPartialTick().getGameTimeDeltaPartialTick(false), event.getCamera().getPosition());
    }

    private static void registerRenderPipelines(RegisterRenderPipelinesEvent event) {
        event.registerPipeline(BlockHighlightRenderHelper.THICK_HIGHLIGHT_PIPELINE);
    }

    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ITEM_HIGHLIGHT_KEYBIND);
        event.register(SORT_KEYBIND);
    }

    public static void handleKeyInput(ClientTickEvent.Post event) {
        if (ITEM_HIGHLIGHT_KEYBIND.consumeClick()) {
            ClientEventHandler.tryHighlightItem();
        }
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        AbstractContainerScreen screen;
        Screen screen2;
        InputConstants.Key key = InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode());
        if (ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(key) && (screen2 = event.getScreen()) instanceof AbstractContainerScreen && ClientEventHandler.tryHighlightItem((screen = (AbstractContainerScreen)screen2).getSlotUnderMouse())) {
            screen.onClose();
            event.setCanceled(true);
        } else if (SORT_KEYBIND.isActiveAndMatches(key) && ClientEventHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        AbstractContainerScreen screen;
        Screen screen2;
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(event.getButton());
        if (ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(input) && (screen2 = event.getScreen()) instanceof AbstractContainerScreen && ClientEventHandler.tryHighlightItem((screen = (AbstractContainerScreen)screen2).getSlotUnderMouse())) {
            screen.onClose();
            event.setCanceled(true);
        } else if (SORT_KEYBIND.isActiveAndMatches(input) && ClientEventHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        }
    }

    private static boolean tryCallSort(Screen gui) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (abstractContainerMenu = mc.player.containerMenu) instanceof StorageContainerMenuBase) {
            double mouseY;
            MouseHandler mh;
            double mouseX;
            StorageScreenBase screen;
            Slot selectedSlot;
            StorageContainerMenuBase container = (StorageContainerMenuBase)abstractContainerMenu;
            if (gui instanceof StorageScreenBase && ((selectedSlot = (screen = (StorageScreenBase)gui).getHoveredSlot(mouseX = (mh = mc.mouseHandler).xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth(), mouseY = mh.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight())) == null || container.isNotPlayersInventorySlot(selectedSlot.index))) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    private static boolean tryHighlightItem(@Nullable Slot slot) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (slot == null || player == null || slot.getItem().isEmpty()) {
            return false;
        }
        ItemInStorageHighlightRenderer.highlightItem(player, slot.getItem());
        return true;
    }

    private static void tryHighlightItem() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.getMainHandItem().isEmpty()) {
            return;
        }
        ItemInStorageHighlightRenderer.highlightItem(player, player.getMainHandItem());
    }

    private static void recipesReceived(RecipesReceivedEvent event) {
        RecipeHelper.setRecipes(event.getRecipeMap());
    }

    private static void onDrawScreen(ScreenEvent.Render.Post event) {
        AbstractContainerScreen containerGui;
        Minecraft mc;
        block8: {
            block7: {
                mc = Minecraft.getInstance();
                Screen gui = mc.screen;
                if (!(gui instanceof AbstractContainerScreen)) break block7;
                containerGui = (AbstractContainerScreen)gui;
                if (!(gui instanceof CreativeModeInventoryScreen) && mc.player != null) break block8;
            }
            return;
        }
        AbstractContainerMenu menu = containerGui.getMenu();
        ItemStack held = menu.getCarried();
        if (!held.isEmpty()) {
            Object object;
            if (menu instanceof StorageContainerMenuBase) {
                StorageContainerMenuBase storageMenu = (StorageContainerMenuBase)menu;
                object = storageMenu.realInventorySlots;
            } else {
                object = menu.slots;
            }
            NonNullList slots = object;
            for (Slot s : slots) {
                Optional<IStashStorageItem.StashResult> stashResult;
                ItemStack stack = s.getItem();
                if (!s.mayPickup((Player)mc.player) || stack.isEmpty() || (stashResult = ClientEventHandler.getStashResult(stack, held)).isEmpty() || s == containerGui.getSlotUnderMouse()) continue;
                ClientEventHandler.renderStashSign(mc, containerGui, event.getGuiGraphics(), s, stack, stashResult.get());
            }
            ClientEventHandler.renderStashTooltip(event, containerGui, held);
        }
    }

    private static void renderStashTooltip(ScreenEvent.Render.Post event, AbstractContainerScreen<?> containerGui, ItemStack held) {
        Slot under = containerGui.getSlotUnderMouse();
        if (under != null) {
            Item item;
            ItemStack inInventory = under.getItem();
            if (inInventory.getCount() == 1 && (item = inInventory.getItem()) instanceof IStashStorageItem) {
                IStashStorageItem stashStorageItem = (IStashStorageItem)item;
                ClientEventHandler.renderSpecialTooltip(event, event.getGuiGraphics(), held, ClientEventHandler.getStashTooltip(inInventory, held, stashStorageItem));
            } else {
                item = held.getItem();
                if (item instanceof IStashStorageItem) {
                    IStashStorageItem stashStorageItem = (IStashStorageItem)item;
                    ClientEventHandler.renderSpecialTooltip(event, event.getGuiGraphics(), inInventory, ClientEventHandler.getStashTooltip(held, inInventory, stashStorageItem));
                }
            }
        }
    }

    private static void renderStashSign(Minecraft mc, AbstractContainerScreen<?> containerGui, GuiGraphics guiGraphics, Slot s, ItemStack stack, IStashStorageItem.StashResult stashResult) {
        int x = containerGui.getGuiLeft() + s.x;
        int y = containerGui.getGuiTop() + s.y;
        int color = ARGB.opaque((int)(stashResult == IStashStorageItem.StashResult.MATCH_AND_SPACE ? ChatFormatting.GREEN.getColor() : 0xFFFF00));
        if (stack.getItem() instanceof IStashStorageItem) {
            guiGraphics.drawString(mc.font, "+", x + 10, y + 8, color);
        } else {
            guiGraphics.drawString(mc.font, "-", x + 1, y, color);
        }
    }

    private static void renderSpecialTooltip(ScreenEvent.Render.Post event, GuiGraphics guiGraphics, ItemStack stack, Optional<TooltipComponent> tooltipComponent) {
        int x = event.getMouseX();
        int y = event.getMouseY();
        GuiHelper.renderTooltip(event.getScreen(), guiGraphics, stack, Collections.singletonList(Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".right_click_to_add_to_storage"))), tooltipComponent, x, y);
    }

    private static Optional<IStashStorageItem.StashResult> getStashResult(ItemStack inInventory, ItemStack held) {
        Item item;
        if (inInventory.getCount() == 1 && (item = inInventory.getItem()) instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)item;
            return ClientEventHandler.getStashResult(inInventory, held, stashStorageItem);
        }
        item = held.getItem();
        if (item instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)item;
            return ClientEventHandler.getStashResult(held, inInventory, stashStorageItem);
        }
        return Optional.empty();
    }

    private static Optional<IStashStorageItem.StashResult> getStashResult(ItemStack potentialStashStorage, ItemStack potentiallyStashable, IStashStorageItem stashStorageItem) {
        IStashStorageItem.StashResult stashResult = stashStorageItem.getItemStashable((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), potentialStashStorage, potentiallyStashable);
        if (stashResult == IStashStorageItem.StashResult.NO_SPACE) {
            return Optional.empty();
        }
        return Optional.of(stashResult);
    }

    private static Optional<TooltipComponent> getStashTooltip(ItemStack potentialStashStorage, ItemStack potentiallyStashable, IStashStorageItem stashStorageItem) {
        if (stashStorageItem.getItemStashable((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), potentialStashStorage, potentiallyStashable) == IStashStorageItem.StashResult.NO_SPACE) {
            return Optional.empty();
        }
        return stashStorageItem.getInventoryTooltip(potentialStashStorage);
    }

    private static void registerFluidClientExtension(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation XP_STILL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedcore", (String)"block/xp_still");
            private static final ResourceLocation XP_FLOWING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedcore", (String)"block/xp_flowing");

            public ResourceLocation getStillTexture() {
                return XP_STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return XP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{ModFluids.XP_FLUID_TYPE.get()});
    }

    private static class ItemHighlightKeyConflictContext
    implements IKeyConflictContext {
        public static final ItemHighlightKeyConflictContext INSTANCE = new ItemHighlightKeyConflictContext();

        private ItemHighlightKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.IN_GAME.isActive() && !Minecraft.getInstance().player.getMainHandItem().isEmpty() || KeyConflictContext.GUI.isActive();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }

    private static class SophisticatedScreenKeyConflictContext
    implements IKeyConflictContext {
        public static final SophisticatedScreenKeyConflictContext INSTANCE = new SophisticatedScreenKeyConflictContext();

        private SophisticatedScreenKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.GUI.isActive() && Minecraft.getInstance().screen instanceof StorageScreenBase;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }
}

