/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common;

import com.google.common.collect.Lists;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.IRecipeDisplayBuilder;

public abstract class ShapedRecipeDisplayBuilder<R>
implements IRecipeDisplayBuilder {
    protected final List<String> rows = Lists.newArrayList();
    protected int width;
    protected int height;

    public ShapedRecipeDisplayBuilder<R> pattern(String patternRow) {
        if (!this.rows.isEmpty() && patternRow.length() != this.rows.getFirst().length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(patternRow);
        return this;
    }

    public abstract ShapedRecipeDisplayBuilder<R> define(Character var1, TagKey<Item> var2);

    public abstract ShapedRecipeDisplayBuilder<R> define(Character var1, ItemLike var2);

    public abstract ShapedRecipeDisplayBuilder<R> define(Character var1, ItemStack var2);

    public abstract ShapedRecipeDisplayBuilder<R> define(Character var1, List<ItemStack> var2);

    public abstract ShapedRecipeDisplayBuilder<R> define(HolderSet<Item> var1);

    public abstract ShapedRecipeDisplayBuilder<R> define(ItemStack var1);

    public ShapedRecipeDisplayBuilder<R> define(Ingredient ingredient) {
        if (ingredient.getCustomIngredient() != null) {
            this.define((HolderSet<Item>)HolderSet.direct(ingredient.getCustomIngredient().items().toList()));
        } else {
            this.define((HolderSet<Item>)ingredient.getValues());
        }
        return this;
    }

    public ShapedRecipeDisplayBuilder<R> defineIngredients(List<Optional<Ingredient>> ingredients) {
        ingredients.forEach(i -> this.define((HolderSet<Item>)i.map(Ingredient::getValues).orElse(HolderSet.empty())));
        return this;
    }

    public abstract ShapedRecipeDisplayBuilder<R> setDimensions(int var1, int var2);

    protected <D> DataResult<List<D>> unpack(Map<Character, D> key, D empty) {
        String[] astring = ShapedRecipePattern.shrink(this.rows);
        this.width = astring[0].length();
        this.height = astring.length;
        ArrayList<D> list = new ArrayList<D>(this.width * this.height);
        CharArraySet charset = new CharArraySet(key.keySet());
        for (String s : astring) {
            for (int k = 0; k < s.length(); ++k) {
                char c = s.charAt(k);
                if (c == ' ') {
                    list.add(empty);
                } else {
                    D displayIngredient = key.get(Character.valueOf(c));
                    if (displayIngredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + c + "' but it's not defined in the key");
                    }
                    list.add(displayIngredient);
                }
                charset.remove(c);
            }
        }
        return !charset.isEmpty() ? DataResult.error(() -> ShapedRecipeDisplayBuilder.lambda$unpack$2((CharSet)charset)) : DataResult.success(list);
    }

    private static /* synthetic */ String lambda$unpack$2(CharSet charset) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charset);
    }
}

