/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.emi;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.registry.EmiTags;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ShapedRecipeDisplayBuilder;

public class EmiShapedRecipeDisplayBuilder
extends ShapedRecipeDisplayBuilder<EmiCraftingRecipe> {
    private final EmiStack output;
    private final Map<Character, EmiIngredient> inputIngredients = new LinkedHashMap<Character, EmiIngredient>();
    private final EmiRegistry registry;
    private List<EmiIngredient> inputs = new ArrayList<EmiIngredient>();

    public EmiShapedRecipeDisplayBuilder(EmiRegistry registry, ItemStack result) {
        this.output = EmiStack.of((ItemStack)result);
        this.registry = registry;
    }

    @Override
    public ShapedRecipeDisplayBuilder<EmiCraftingRecipe> define(Character symbol, TagKey<Item> tag) {
        this.inputIngredients.put(symbol, EmiIngredient.of(tag));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<EmiCraftingRecipe> define(Character symbol, ItemLike item) {
        this.inputIngredients.put(symbol, (EmiIngredient)EmiStack.of((ItemLike)item));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<EmiCraftingRecipe> define(Character symbol, ItemStack itemStack) {
        this.inputIngredients.put(symbol, (EmiIngredient)EmiStack.of((ItemStack)itemStack));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<EmiCraftingRecipe> define(Character symbol, List<ItemStack> itemStacks) {
        this.inputIngredients.put(symbol, EmiTags.getIngredient(Item.class, itemStacks.stream().map(EmiStack::of).toList(), (long)1L));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<EmiCraftingRecipe> define(HolderSet<Item> items) {
        this.inputs.add(EmiTags.getIngredient(Item.class, items.stream().map(h -> EmiStack.of((ItemLike)((ItemLike)h.value()))).toList(), (long)1L));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<EmiCraftingRecipe> define(ItemStack itemStack) {
        this.inputs.add((EmiIngredient)EmiStack.of((ItemStack)itemStack));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<EmiCraftingRecipe> setDimensions(int width, int height) {
        return this;
    }

    @Override
    public void save(ResourceKey<Recipe<?>> id) {
        if (!this.inputIngredients.isEmpty()) {
            this.inputs = (List)this.unpack(this.inputIngredients, EmiStack.EMPTY).getOrThrow();
        }
        this.registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(this.inputs, this.output, id.location()));
    }
}

