/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.neoforge.NeoForgeTypes;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IFilterSlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.SetGhostSlotPayload;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeTab;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;

public class JeiStorageGhostIngredientHandler<S extends StorageScreenBase<?>>
implements IGhostIngredientHandler<S> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(S gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList targets = new ArrayList();
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            StorageContainerMenuBase container = (StorageContainerMenuBase)gui.getMenu();
            ingredient.getItemStack().ifPresent(ghostStack -> {
                FluidStack fluidStack = CapabilityHelper.getFromCapability(ghostStack, Capabilities.FluidHandler.ITEM, null, fluidHandler -> fluidHandler.getTanks() > 0 ? fluidHandler.getFluidInTank(0) : FluidStack.EMPTY, FluidStack.EMPTY);
                if (!fluidStack.isEmpty()) {
                    gui.getUpgradeSettingsControl().getOpenTab().filter(tab -> tab instanceof PumpUpgradeTab.Advanced).map(PumpUpgradeTab.Advanced.class::cast).ifPresent(pumpUpgradeTab -> this.addFluidTargets((PumpUpgradeTab.Advanced)pumpUpgradeTab, fluidStack, targets));
                    return;
                }
                container.getOpenContainer().ifPresent(c -> c.getSlots().forEach(s -> {
                    if (s instanceof IFilterSlot && s.mayPlace(ghostStack)) {
                        targets.add(new IGhostIngredientHandler.Target<I>(this, (StorageScreenBase)gui, (Slot)s, (ItemStack)ghostStack){
                            final /* synthetic */ StorageScreenBase val$gui;
                            final /* synthetic */ Slot val$s;
                            final /* synthetic */ ItemStack val$ghostStack;
                            {
                                this.val$gui = storageScreenBase;
                                this.val$s = slot;
                                this.val$ghostStack = itemStack;
                            }

                            public Rect2i getArea() {
                                return new Rect2i(this.val$gui.getGuiLeft() + this.val$s.x, this.val$gui.getGuiTop() + this.val$s.y, 17, 17);
                            }

                            public void accept(I i) {
                                ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetGhostSlotPayload(this.val$ghostStack, this.val$s.index), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                        });
                    }
                }));
            });
        } else if (ingredient.getType() == NeoForgeTypes.FLUID_STACK) {
            ((StorageScreenBase)gui).getUpgradeSettingsControl().getOpenTab().filter(tab -> tab instanceof PumpUpgradeTab.Advanced).map(PumpUpgradeTab.Advanced.class::cast).ifPresent(pumpUpgradeTab -> NeoForgeTypes.FLUID_STACK.castIngredient(ingredient.getIngredient()).ifPresent(ghostFluid -> this.addFluidTargets((PumpUpgradeTab.Advanced)pumpUpgradeTab, (FluidStack)ghostFluid, targets)));
        }
        return targets;
    }

    private <I> void addFluidTargets(final PumpUpgradeTab.Advanced pumpUpgradeTab, final FluidStack ghostFluid, List<IGhostIngredientHandler.Target<I>> targets) {
        List<Position> slotTopLeftPositions = pumpUpgradeTab.getFluidFilterControl().getSlotTopLeftPositions();
        final AtomicInteger slot = new AtomicInteger();
        slot.set(0);
        while (slot.get() < slotTopLeftPositions.size()) {
            final Position position = slotTopLeftPositions.get(slot.get());
            targets.add(new IGhostIngredientHandler.Target<I>(this){
                private final int slotIndex;
                {
                    this.slotIndex = slot.get();
                }

                public Rect2i getArea() {
                    return new Rect2i(position.x(), position.y(), 17, 17);
                }

                public void accept(I i) {
                    pumpUpgradeTab.getFluidFilterControl().setFluid(this.slotIndex, ghostFluid);
                }
            });
            slot.incrementAndGet();
        }
    }

    public void onComplete() {
    }
}

