/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.impl.client.transfer.SimpleTransferHandlerImpl;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiSlotAccessor;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiTransferRecipePayload;

public class ReiCraftingContainerTransferHandler<C extends StorageContainerMenuBase<?>, D extends Display>
implements SimpleTransferHandler {
    private final Class<? extends C> containerClass;
    private final CategoryIdentifier<D> categoryIdentifier;
    private final RecipeType<? extends Recipe<?>> recipeType;

    public static <C extends StorageContainerMenuBase<?>> TransferHandler crafting(Class<? extends C> containerClass) {
        return new ReiCraftingContainerTransferHandler(containerClass, BuiltinPlugin.CRAFTING, RecipeType.CRAFTING);
    }

    public static <C extends StorageContainerMenuBase<?>> TransferHandler smithing(Class<? extends C> containerClass) {
        return new ReiCraftingContainerTransferHandler(containerClass, BuiltinPlugin.SMITHING, RecipeType.SMITHING);
    }

    public ReiCraftingContainerTransferHandler(Class<? extends C> containerClass, CategoryIdentifier<D> categoryIdentifier, RecipeType<? extends Recipe<?>> recipeType) {
        this.containerClass = containerClass;
        this.categoryIdentifier = categoryIdentifier;
        this.recipeType = recipeType;
    }

    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        if (!this.containerClass.isInstance(context.getMenu()) || ((StorageContainerMenuBase)context.getMenu()).getOpenOrFirstCraftingContainer(this.recipeType).isEmpty() || !this.categoryIdentifier.equals((Object)context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        return TransferHandler.ApplicabilityResult.createApplicable();
    }

    public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
        StorageContainerMenuBase storageContainerMenuBase = (StorageContainerMenuBase)context.getMenu();
        return storageContainerMenuBase.getOpenOrFirstCraftingContainer(this.recipeType).map(c -> ((ICraftingContainer)((Object)c)).getRecipeSlots().stream().map(ReiSlotAccessor::fromSlot).toList()).orElse(List.of());
    }

    public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
        StorageContainerMenuBase storageContainerMenuBase = (StorageContainerMenuBase)context.getMenu();
        return storageContainerMenuBase.realInventorySlots.stream().map(ReiSlotAccessor::fromSlot).toList();
    }

    public TransferHandler.Result handle(TransferHandler.Context context) {
        List inputs = this.getInputsIndexed(context);
        List inputSlots = (List)this.getInputSlots(context);
        List inventorySlots = (List)this.getInventorySlots(context);
        List missing = SimpleTransferHandlerImpl.hasItemsIndexed((TransferHandler.Context)context, (Iterable)inventorySlots, (List)inputs);
        if (!missing.isEmpty()) {
            IntLinkedOpenHashSet missingIndices = new IntLinkedOpenHashSet(missing.size());
            for (InputIngredient ingredient2 : missing) {
                missingIndices.add(ingredient2.getDisplayIndex());
            }
            return TransferHandler.Result.createFailed((Component)Component.translatable((String)"error.rei.not.enough.materials")).renderer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> this.lambda$handle$1(context, inputs, missing, (IntSet)missingIndices, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6)).tooltipMissing(CollectionUtils.map((Collection)missing, ingredient -> EntryIngredients.ofItemStacks((Collection)ingredient.get())));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        StorageContainerMenuBase storageContainerMenuBase = (StorageContainerMenuBase)context.getMenu();
        storageContainerMenuBase.getOpenOrFirstCraftingContainer(this.recipeType).ifPresent(openOrFirstCraftingContainer -> {
            if (!openOrFirstCraftingContainer.isOpen()) {
                storageContainerMenuBase.getOpenContainer().ifPresent(c -> {
                    c.setIsOpen(false);
                    storageContainerMenuBase.setOpenTabId(-1);
                });
                openOrFirstCraftingContainer.setIsOpen(true);
                storageContainerMenuBase.setOpenTabId(openOrFirstCraftingContainer.getUpgradeContainerId());
            }
        });
        AbstractContainerScreen containerScreen = context.getContainerScreen();
        context.getMinecraft().setScreen((Screen)containerScreen);
        ResourceLocation recipeTypeId = BuiltInRegistries.RECIPE_TYPE.getKey(this.recipeType);
        if (recipeTypeId != null) {
            List<Integer> inputSlotIds = inputSlots.stream().map(ReiSlotAccessor.class::cast).map(ReiSlotAccessor::getIndex).toList();
            List<Integer> inventorySlotIds = inventorySlots.stream().map(ReiSlotAccessor.class::cast).map(ReiSlotAccessor::getIndex).toList();
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ReiTransferRecipePayload((ResourceLocation)context.getDisplay().getDisplayLocation().get(), recipeTypeId, ReiCraftingContainerTransferHandler.save(inputs), inputSlotIds, inventorySlotIds, context.isStackedCrafting()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return TransferHandler.Result.createSuccessful();
    }

    private static CompoundTag save(List<InputIngredient<ItemStack>> inputs) {
        CompoundTag tag = new CompoundTag();
        tag.put("Inputs", ReiCraftingContainerTransferHandler.saveInputs(inputs));
        return tag;
    }

    private static Tag saveInputs(List<InputIngredient<ItemStack>> inputs) {
        ListTag tag = new ListTag();
        for (InputIngredient<ItemStack> input : inputs) {
            CompoundTag innerTag = new CompoundTag();
            innerTag.put("Ingredient", (Tag)EntryIngredient.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)EntryIngredients.ofItemStacks((Collection)input.get())).getOrThrow());
            innerTag.putInt("Index", input.getIndex());
            tag.add((Object)innerTag);
        }
        return tag;
    }

    private /* synthetic */ void lambda$handle$1(TransferHandler.Context context, List inputs, List missing, IntSet missingIndices, GuiGraphics matrices, int mouseX, int mouseY, float delta, List widgets, Rectangle bounds, Display d) {
        this.getMissingInputRenderer().renderMissingInput(context, inputs, missing, missingIndices, matrices, mouseX, mouseY, delta, widgets, bounds);
    }
}

