/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapedDisplay;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ShapedRecipeDisplayBuilder;

public class ReiShapedRecipeDisplayBuilder
extends ShapedRecipeDisplayBuilder<Display> {
    private final List<EntryIngredient> output;
    private final Map<Character, EntryIngredient> inputEntryIngredients = new LinkedHashMap<Character, EntryIngredient>();
    private final DisplayRegistry registry;
    private List<EntryIngredient> inputs = new ArrayList<EntryIngredient>();

    public ReiShapedRecipeDisplayBuilder(DisplayRegistry registry, ItemStack result) {
        this.registry = registry;
        this.output = List.of(EntryIngredients.of((ItemStack)result));
    }

    @Override
    public ShapedRecipeDisplayBuilder<Display> define(Character symbol, TagKey<Item> tag) {
        this.inputEntryIngredients.put(symbol, EntryIngredients.ofTag((HolderGetter.Provider)BasicDisplay.registryAccess(), tag, EntryStacks::ofItemHolder));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<Display> define(Character symbol, ItemLike item) {
        this.inputEntryIngredients.put(symbol, EntryIngredients.of((ItemLike)item));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<Display> define(Character symbol, ItemStack itemStack) {
        this.inputEntryIngredients.put(symbol, EntryIngredients.of((ItemStack)itemStack));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<Display> define(Character symbol, List<ItemStack> itemStacks) {
        this.inputEntryIngredients.put(symbol, EntryIngredients.ofItemStacks(itemStacks));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<Display> define(HolderSet<Item> items) {
        this.inputs.add(EntryIngredients.ofItemsHolderSet(items));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<Display> define(ItemStack itemStack) {
        this.inputs.add(EntryIngredients.of((ItemStack)itemStack));
        return this;
    }

    @Override
    public ShapedRecipeDisplayBuilder<Display> setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public void save(ResourceKey<Recipe<?>> id) {
        if (!this.inputEntryIngredients.isEmpty()) {
            this.inputs = (List)this.unpack(this.inputEntryIngredients, EntryIngredient.empty()).getOrThrow();
        }
        this.registry.add((Display)new DefaultCustomShapedDisplay(this.inputs, this.output, Optional.of(id.location()), this.width, this.height));
    }
}

