/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public interface IControllerBoundable {
    public static final String CONTROLLER_POS = "controllerPos";

    public void setControllerPos(BlockPos var1);

    public Optional<BlockPos> getControllerPos();

    public void removeControllerPos();

    public BlockPos getStorageBlockPos();

    public Level getStorageBlockLevel();

    default public boolean canBeConnected() {
        return this.getControllerPos().isEmpty();
    }

    public void registerController(ControllerBlockEntityBase var1);

    public void unregisterController();

    public boolean canConnectStorages();

    default public void runOnController(Level level, Consumer<ControllerBlockEntityBase> toRun) {
        this.getControllerPos().flatMap(pos -> WorldHelper.getLoadedBlockEntity(level, pos, ControllerBlockEntityBase.class)).ifPresent(toRun);
    }

    default public void saveControllerPos(ValueOutput out) {
        this.getControllerPos().ifPresent(pos -> out.store(CONTROLLER_POS, BlockPos.CODEC, pos));
    }

    default public void loadControllerPos(ValueInput in) {
        in.read(CONTROLLER_POS, BlockPos.CODEC).ifPresent(this::setControllerPos);
    }

    default public void addToController(Level level, BlockPos pos, BlockPos controllerPos) {
    }

    default public void addToAdjacentController() {
        Level level = this.getStorageBlockLevel();
        if (!level.isClientSide()) {
            BlockPos pos = this.getStorageBlockPos();
            for (Direction dir : Direction.values()) {
                BlockPos offsetPos = pos.offset(dir.getUnitVec3i());
                WorldHelper.getBlockEntity((BlockGetter)level, offsetPos, IControllerBoundable.class).ifPresentOrElse(s -> {
                    if (s.canConnectStorages()) {
                        s.getControllerPos().ifPresent(controllerPos -> this.addToController(level, pos, (BlockPos)controllerPos));
                    }
                }, () -> this.addToController(level, pos, offsetPos));
                if (this.getControllerPos().isPresent()) break;
            }
        }
    }
}

