/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.renderdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeClientDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public abstract class RenderInfo {
    private static final String TANKS_TAG = "tanks";
    private static final String BATTERY_TAG = "battery";
    private static final String TANK_POSITION_TAG = "position";
    private static final String TANK_INFO_TAG = "info";
    private static final String ITEM_DISPLAY_TAG = "itemDisplay";
    private static final String UPGRADES_TAG = "upgrades";
    private static final String UPGRADE_ITEMS_TAG = "upgradeItems";
    private static final Map<String, UpgradeClientDataType<?>> CLIENT_DATA_TYPES = Map.of(CookingUpgradeClientData.TYPE.getName(), CookingUpgradeClientData.TYPE, JukeboxUpgradeClientData.TYPE.getName(), JukeboxUpgradeClientData.TYPE);
    private ItemDisplayRenderInfo itemDisplayRenderInfo;
    private final Supplier<Runnable> getSaveHandler;
    private final boolean showsCountsAndFillRatios;
    private final List<ItemStack> upgradeItems = new ArrayList<ItemStack>();
    private final Map<UpgradeClientDataType<?>, IUpgradeClientData> clientData = new HashMap();
    private final Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> tankRenderInfos = new LinkedHashMap<TankPosition, IRenderedTankUpgrade.TankRenderInfo>();
    @Nullable
    private IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo = null;
    private Consumer<RenderInfo> displayItemsChangeListener = ri -> {};

    protected RenderInfo(Supplier<Runnable> getSaveHandler) {
        this(getSaveHandler, false);
    }

    protected RenderInfo(Supplier<Runnable> getSaveHandler, boolean showsCountsAndFillRatios) {
        this.getSaveHandler = getSaveHandler;
        this.showsCountsAndFillRatios = showsCountsAndFillRatios;
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo();
    }

    public ItemDisplayRenderInfo getItemDisplayRenderInfo() {
        return this.itemDisplayRenderInfo;
    }

    public void setUpgradeItems(List<ItemStack> upgradeItems) {
        this.upgradeItems.clear();
        this.upgradeItems.addAll(upgradeItems);
        this.serializeUpgradeItems();
        this.save();
    }

    private void serializeUpgradeItems() {
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        ListTag upgradeItemsTag = new ListTag();
        for (ItemStack upgradeItem : this.upgradeItems) {
            if (!upgradeItem.isEmpty()) {
                NBTHelper.serializeStackToTag(upgradeItem).ifPresent(arg_0 -> upgradeItemsTag.add(arg_0));
                continue;
            }
            upgradeItemsTag.add((Object)new CompoundTag());
        }
        renderInfo.put(UPGRADE_ITEMS_TAG, (Tag)upgradeItemsTag);
        this.serializeRenderInfo(renderInfo);
    }

    public <T extends IUpgradeClientData> void setUpgradeClientData(UpgradeClientDataType<T> upgradeClientDataType, T clientData) {
        this.clientData.put(upgradeClientDataType, clientData);
        this.serializeUpgradeData(upgrades -> upgrades.put(upgradeClientDataType.getName(), (Tag)clientData.serializeNBT()));
        this.save();
    }

    public <T extends IUpgradeClientData> Optional<T> getUpgradeClientData(UpgradeClientDataType<T> upgradeClientDataType) {
        if (!this.clientData.containsKey(upgradeClientDataType)) {
            return Optional.empty();
        }
        return upgradeClientDataType.cast(this.clientData.get(upgradeClientDataType));
    }

    private void serializeUpgradeData(Consumer<CompoundTag> modifyUpgradesTag) {
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        CompoundTag upgrades = renderInfo.getCompoundOrEmpty(UPGRADES_TAG);
        modifyUpgradesTag.accept(upgrades);
        renderInfo.put(UPGRADES_TAG, (Tag)upgrades);
        this.serializeRenderInfo(renderInfo);
    }

    public void refreshItemDisplayRenderInfo(List<DisplayItem> displayItems, List<Integer> inaccessibleSlots, List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo(displayItems, inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.put(ITEM_DISPLAY_TAG, (Tag)this.itemDisplayRenderInfo.serialize());
        this.serializeRenderInfo(renderInfo);
        this.save();
        this.displayItemsChangeListener.accept(this);
    }

    public void refreshDisplayItemsAndInaccessibleSlots(List<DisplayItem> displayItems, List<Integer> inaccessibleSlots) {
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo(displayItems, inaccessibleSlots, this.itemDisplayRenderInfo.getInfiniteSlots(), this.itemDisplayRenderInfo.getSlotCounts(), this.itemDisplayRenderInfo.getSlotFillRatios());
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.put(ITEM_DISPLAY_TAG, (Tag)this.itemDisplayRenderInfo.serialize());
        this.serializeRenderInfo(renderInfo);
        this.save();
        this.displayItemsChangeListener.accept(this);
    }

    public void refreshSlotCountsFillRatiosAndInfiniteSlots(List<Integer> slotCounts, List<Float> slotFillRatios, List<Integer> infiniteSlots) {
        this.itemDisplayRenderInfo = new ItemDisplayRenderInfo(this.itemDisplayRenderInfo.getDisplayItems(), this.itemDisplayRenderInfo.getInaccessibleSlots(), infiniteSlots, slotCounts, slotFillRatios);
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.put(ITEM_DISPLAY_TAG, (Tag)this.itemDisplayRenderInfo.serialize());
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public void setDisplayItemsChangeListener(Consumer<RenderInfo> displayItemsChangeListener) {
        this.displayItemsChangeListener = displayItemsChangeListener;
    }

    protected void save(boolean triggerChangeListener) {
        this.getSaveHandler.get().run();
        if (triggerChangeListener) {
            this.displayItemsChangeListener.accept(this);
        }
    }

    protected void save() {
        this.save(false);
    }

    protected abstract void serializeRenderInfo(CompoundTag var1);

    protected void deserialize() {
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            this.deserializeItemDisplay((CompoundTag)renderInfoTag);
            this.deserializeUpgradeItems((CompoundTag)renderInfoTag);
            this.deserializeUpgradeData((CompoundTag)renderInfoTag);
            this.deserializeTanks((CompoundTag)renderInfoTag);
            this.deserializeBattery((CompoundTag)renderInfoTag);
        });
    }

    private void deserializeUpgradeItems(CompoundTag renderInfoTag) {
        ListTag upgradeItemsTag = renderInfoTag.getListOrEmpty(UPGRADE_ITEMS_TAG);
        this.upgradeItems.clear();
        RegistryHelper.getRegistryAccess().ifPresent(registryAccess -> {
            for (int i = 0; i < upgradeItemsTag.size(); ++i) {
                this.upgradeItems.add(NBTHelper.deserializeStackFromTag((Tag)upgradeItemsTag.getCompoundOrEmpty(i)).orElse(ItemStack.EMPTY));
            }
        });
    }

    private void deserializeItemDisplay(CompoundTag renderInfoTag) {
        this.itemDisplayRenderInfo = ItemDisplayRenderInfo.deserialize(renderInfoTag.getCompoundOrEmpty(ITEM_DISPLAY_TAG));
    }

    protected abstract Optional<CompoundTag> getRenderInfoTag();

    public Map<UpgradeClientDataType<?>, IUpgradeClientData> getUpgradeClientData() {
        return this.clientData;
    }

    public void removeAllUpgradeClientData() {
        this.clientData.clear();
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.remove(UPGRADES_TAG);
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public void removeUpgradeClientData(UpgradeClientDataType<?> type) {
        this.clientData.remove(type);
        this.serializeUpgradeData(upgrades -> upgrades.remove(type.getName()));
        this.save();
    }

    private void deserializeUpgradeData(CompoundTag renderInfoTag) {
        CompoundTag upgrades = renderInfoTag.getCompoundOrEmpty(UPGRADES_TAG);
        upgrades.keySet().forEach(key -> {
            if (CLIENT_DATA_TYPES.containsKey(key)) {
                UpgradeClientDataType<?> upgradeClientDataType = CLIENT_DATA_TYPES.get(key);
                this.clientData.put(upgradeClientDataType, (IUpgradeClientData)upgradeClientDataType.deserialize(upgrades.getCompoundOrEmpty(key)));
            }
        });
    }

    public CompoundTag getNbt() {
        return this.getRenderInfoTag().orElse(new CompoundTag());
    }

    public void deserializeFrom(CompoundTag renderInfoNbt) {
        this.resetUpgradeInfo(false);
        this.clientData.clear();
        this.serializeRenderInfo(renderInfoNbt);
        this.deserialize();
    }

    public void resetUpgradeInfo(boolean triggerChangeListener) {
        this.tankRenderInfos.clear();
        this.batteryRenderInfo = null;
        this.getRenderInfoTag().ifPresent(renderInfoTag -> {
            renderInfoTag.remove(TANKS_TAG);
            renderInfoTag.remove(BATTERY_TAG);
            this.serializeRenderInfo((CompoundTag)renderInfoTag);
        });
        this.save(triggerChangeListener);
    }

    public void setTankRenderInfo(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        this.tankRenderInfos.put(tankPosition, tankRenderInfo);
        this.serializeTank(tankPosition, tankRenderInfo);
        this.save();
    }

    private void deserializeTanks(CompoundTag renderInfoTag) {
        ListTag tanks = renderInfoTag.getListOrEmpty(TANKS_TAG);
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.getCompoundOrEmpty(i);
            this.tankRenderInfos.put(tank.getString(TANK_POSITION_TAG).map(s -> TankPosition.valueOf(s.toUpperCase(Locale.ROOT))).orElse(TankPosition.LEFT), IRenderedTankUpgrade.TankRenderInfo.deserialize(tank.getCompoundOrEmpty(TANK_INFO_TAG)));
        }
    }

    private void deserializeBattery(CompoundTag renderInfoTag) {
        this.batteryRenderInfo = NBTHelper.getCompound(renderInfoTag, BATTERY_TAG).map(IRenderedBatteryUpgrade.BatteryRenderInfo::deserialize).orElse(null);
    }

    private void serializeTank(TankPosition tankPosition, IRenderedTankUpgrade.TankRenderInfo tankRenderInfo) {
        CompoundTag tankInfo = tankRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        ListTag tanks = renderInfo.getListOrEmpty(TANKS_TAG);
        boolean infoSet = false;
        for (int i = 0; i < tanks.size(); ++i) {
            CompoundTag tank = tanks.getCompoundOrEmpty(i);
            if (!tank.getString(TANK_POSITION_TAG).map(positionString -> positionString.equals(tankPosition.getSerializedName())).orElse(false).booleanValue()) continue;
            tank.put(TANK_INFO_TAG, (Tag)tankInfo);
            infoSet = true;
        }
        if (!infoSet) {
            CompoundTag tankPositionInfo = new CompoundTag();
            tankPositionInfo.putString(TANK_POSITION_TAG, tankPosition.getSerializedName());
            tankPositionInfo.put(TANK_INFO_TAG, (Tag)tankInfo);
            tanks.add((Object)tankPositionInfo);
            renderInfo.put(TANKS_TAG, (Tag)tanks);
        }
        this.serializeRenderInfo(renderInfo);
    }

    public Map<TankPosition, IRenderedTankUpgrade.TankRenderInfo> getTankRenderInfos() {
        return this.tankRenderInfos;
    }

    public Optional<IRenderedBatteryUpgrade.BatteryRenderInfo> getBatteryRenderInfo() {
        return Optional.ofNullable(this.batteryRenderInfo);
    }

    public void setBatteryRenderInfo(IRenderedBatteryUpgrade.BatteryRenderInfo batteryRenderInfo) {
        this.batteryRenderInfo = batteryRenderInfo;
        CompoundTag batteryInfo = batteryRenderInfo.serialize();
        CompoundTag renderInfo = this.getRenderInfoTag().orElse(new CompoundTag());
        renderInfo.put(BATTERY_TAG, (Tag)batteryInfo);
        this.serializeRenderInfo(renderInfo);
        this.save();
    }

    public List<ItemStack> getUpgradeItems() {
        return this.upgradeItems;
    }

    public boolean showsCountsAndFillRatios() {
        return this.showsCountsAndFillRatios;
    }

    public static class ItemDisplayRenderInfo {
        private static final String ITEMS_TAG = "items";
        private static final String INACCESSIBLE_SLOTS_TAG = "inaccessibleSlots";
        private static final String INFINITE_SLOTS_TAG = "infiniteSlots";
        public static final String SLOT_COUNTS_TAG = "slotCounts";
        public static final String SLOT_FILL_RATIOS_TAG = "slotFillRatios";
        private final List<DisplayItem> displayItems;
        private final List<Integer> inaccessibleSlots;
        private final List<Integer> infiniteSlots;
        private final List<Integer> slotCounts;
        private final List<Float> slotFillRatios;

        private ItemDisplayRenderInfo(DisplayItem displayItem, List<Integer> inaccessibleSlots, List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
            this(List.of(displayItem), inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
        }

        private ItemDisplayRenderInfo(List<DisplayItem> displayItems, List<Integer> inaccessibleSlots, List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
            this.displayItems = displayItems;
            this.inaccessibleSlots = inaccessibleSlots;
            this.infiniteSlots = infiniteSlots;
            this.slotCounts = slotCounts;
            this.slotFillRatios = slotFillRatios;
        }

        public ItemDisplayRenderInfo() {
            this(new ArrayList<DisplayItem>(), new ArrayList<Integer>(), new ArrayList<Integer>(), Collections.emptyList(), Collections.emptyList());
        }

        public CompoundTag serialize() {
            CompoundTag ret = new CompoundTag();
            if (this.displayItems.size() == 1) {
                this.displayItems.getFirst().serialize(ret);
            } else if (this.displayItems.size() > 1) {
                NBTHelper.putList(ret, ITEMS_TAG, this.displayItems, displayItem -> displayItem.serialize(new CompoundTag()));
            }
            ret.putIntArray(INACCESSIBLE_SLOTS_TAG, this.inaccessibleSlots.stream().mapToInt(i -> i).toArray());
            ret.putIntArray(INFINITE_SLOTS_TAG, this.infiniteSlots.stream().mapToInt(i -> i).toArray());
            ret.putIntArray(SLOT_COUNTS_TAG, this.slotCounts.stream().mapToInt(i -> i).toArray());
            NBTHelper.putList(ret, SLOT_FILL_RATIOS_TAG, this.slotFillRatios, FloatTag::valueOf);
            return ret;
        }

        public static ItemDisplayRenderInfo deserialize(CompoundTag tag) {
            List<Integer> inaccessibleSlots = tag.getIntArray(INACCESSIBLE_SLOTS_TAG).map(array -> Arrays.stream(array).boxed().collect(Collectors.toCollection(ArrayList::new))).orElse(Collections.emptyList());
            List<Integer> infiniteSlots = tag.getIntArray(INFINITE_SLOTS_TAG).map(array -> Arrays.stream(array).boxed().collect(Collectors.toCollection(ArrayList::new))).orElse(Collections.emptyList());
            List<Integer> slotCounts = tag.getIntArray(SLOT_COUNTS_TAG).map(array -> Arrays.stream(array).boxed().collect(Collectors.toCollection(ArrayList::new))).orElse(Collections.emptyList());
            List slotFillRatios = NBTHelper.getCollection(tag, SLOT_FILL_RATIOS_TAG, Tag::asFloat, ArrayList::new).orElseGet(ArrayList::new);
            if (tag.contains("item")) {
                return new ItemDisplayRenderInfo(DisplayItem.deserialize(tag), inaccessibleSlots, infiniteSlots, slotCounts, (List<Float>)slotFillRatios);
            }
            if (tag.contains(ITEMS_TAG)) {
                List items = NBTHelper.getCollection(tag, ITEMS_TAG, stackTag -> Optional.of(DisplayItem.deserialize((CompoundTag)stackTag)), ArrayList::new).orElseGet(ArrayList::new);
                return new ItemDisplayRenderInfo(items, inaccessibleSlots, infiniteSlots, slotCounts, (List<Float>)slotFillRatios);
            }
            return new ItemDisplayRenderInfo();
        }

        public Optional<DisplayItem> getDisplayItem() {
            return !this.displayItems.isEmpty() ? Optional.of(this.displayItems.getFirst()) : Optional.empty();
        }

        public List<DisplayItem> getDisplayItems() {
            return this.displayItems;
        }

        public List<Integer> getInaccessibleSlots() {
            return this.inaccessibleSlots;
        }

        public List<Integer> getSlotCounts() {
            return this.slotCounts;
        }

        public List<Integer> getInfiniteSlots() {
            return this.infiniteSlots;
        }

        public List<Float> getSlotFillRatios() {
            return this.slotFillRatios;
        }
    }

    public static class DisplayItem {
        private static final String ITEM_TAG = "item";
        private static final String ROTATION_TAG = "rotation";
        private static final String SLOT_INDEX_TAG = "slotIndex";
        private static final String DISPLAY_SIDE_TAG = "displaySide";
        private final ItemStack item;
        private final int rotation;
        private final int slotIndex;
        private final DisplaySide displaySide;

        public DisplayItem(ItemStack item, int rotation, int slotIndex, DisplaySide displaySide) {
            this.item = item;
            this.rotation = rotation;
            this.slotIndex = slotIndex;
            this.displaySide = displaySide;
        }

        private CompoundTag serialize(CompoundTag tag) {
            if (!this.item.isEmpty()) {
                NBTHelper.serializeStackToTag(this.item).ifPresent(itemTag -> tag.put(ITEM_TAG, itemTag));
            } else {
                tag.put(ITEM_TAG, (Tag)new CompoundTag());
            }
            tag.putInt(ROTATION_TAG, this.rotation);
            tag.putInt(SLOT_INDEX_TAG, this.slotIndex);
            tag.putString(DISPLAY_SIDE_TAG, this.displaySide.getSerializedName());
            return tag;
        }

        private static DisplayItem deserialize(CompoundTag tag) {
            return new DisplayItem(tag.getCompound(ITEM_TAG).flatMap(NBTHelper::deserializeStackFromTag).orElse(ItemStack.EMPTY), tag.getIntOr(ROTATION_TAG, 0), tag.getIntOr(SLOT_INDEX_TAG, 0), tag.getString(DISPLAY_SIDE_TAG).map(DisplaySide::fromName).orElse(DisplaySide.FRONT));
        }

        public ItemStack getItem() {
            return this.item;
        }

        public int getRotation() {
            return this.rotation;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public DisplaySide getDisplaySide() {
            return this.displaySide;
        }
    }
}

