/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.memory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class MemorySettingsCategory
implements ISettingsCategory<MemorySettingsCategory> {
    public static final String NAME = "memory";
    private static final String SLOT_FILTER_ITEMS_TAG = "slotFilterItems";
    private static final String SLOT_FILTER_STACKS_TAG = "slotFilterStacks";
    private static final String IGNORE_NBT_TAG = "ignoreNbt";
    private final Supplier<InventoryHandler> inventoryHandlerSupplier;
    private CompoundTag categoryNbt;
    private final Consumer<CompoundTag> saveNbt;
    private final Map<Integer, Item> slotFilterItems = new LinkedHashMap<Integer, Item>();
    private final Map<Integer, ItemStackKey> slotFilterStacks = new LinkedHashMap<Integer, ItemStackKey>();
    private final Map<Item, Set<Integer>> filterItemSlots = new HashMap<Item, Set<Integer>>();
    private final Map<Integer, Set<Integer>> filterStackSlots = new HashMap<Integer, Set<Integer>>();
    private boolean ignoreNbt = true;
    private Consumer<Item> onItemAdded = i -> {};
    private Consumer<Integer> onStackAdded = i -> {};
    private Consumer<Item> onItemRemoved = i -> {};
    private Consumer<Integer> onStackRemoved = i -> {};

    public MemorySettingsCategory(Supplier<InventoryHandler> inventoryHandlerSupplier, CompoundTag categoryNbt, Consumer<CompoundTag> saveNbt) {
        this.inventoryHandlerSupplier = inventoryHandlerSupplier;
        this.categoryNbt = categoryNbt;
        this.saveNbt = saveNbt;
        this.deserialize();
    }

    private void deserialize() {
        NBTHelper.getMap(this.categoryNbt, SLOT_FILTER_ITEMS_TAG, Integer::valueOf, (k, v) -> BuiltInRegistries.ITEM.getOptional((ResourceLocation)v.asString().map(ResourceLocation::parse).orElse(null))).ifPresent(map -> map.forEach(this::addSlotItem));
        NBTHelper.getMap(this.categoryNbt, SLOT_FILTER_STACKS_TAG, Integer::valueOf, (k, v) -> {
            Optional<Object> optional;
            if (v instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)v;
                optional = NBTHelper.deserializeStackFromTag((Tag)tag);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }).ifPresent(map -> map.forEach(this::addSlotStack));
        this.ignoreNbt = NBTHelper.getBoolean(this.categoryNbt, IGNORE_NBT_TAG).orElse(true);
    }

    public boolean matchesFilter(int slotNumber, ItemStack stack) {
        if (this.slotFilterItems.containsKey(slotNumber)) {
            return !stack.isEmpty() && stack.getItem() == this.slotFilterItems.get(slotNumber);
        }
        if (this.slotFilterStacks.containsKey(slotNumber)) {
            return !stack.isEmpty() && this.slotFilterStacks.get(slotNumber).matches(stack);
        }
        return true;
    }

    public Optional<ItemStack> getSlotFilterStack(int slotNumber, boolean copy) {
        if (this.slotFilterItems.containsKey(slotNumber)) {
            return Optional.of(new ItemStack((ItemLike)this.slotFilterItems.get(slotNumber)));
        }
        if (this.slotFilterStacks.containsKey(slotNumber)) {
            ItemStack filterStack = this.slotFilterStacks.get(slotNumber).getStack();
            return Optional.of(copy ? filterStack.copy() : filterStack);
        }
        return Optional.empty();
    }

    public boolean isSlotSelected(int slotNumber) {
        return this.slotFilterItems.containsKey(slotNumber) || this.slotFilterStacks.containsKey(slotNumber);
    }

    public void unselectAllSlots() {
        this.unselectAllFilterItemSlots();
        this.unselectAllFilteStackSlots();
        this.serializeFilterItems();
    }

    private void unselectAllFilteStackSlots() {
        this.filterStackSlots.keySet().forEach(i -> this.onStackRemoved.accept((Integer)i));
        this.slotFilterStacks.clear();
        this.filterStackSlots.clear();
    }

    private void unselectAllFilterItemSlots() {
        this.filterItemSlots.keySet().forEach(i -> this.onItemRemoved.accept((Item)i));
        this.slotFilterItems.clear();
        this.filterItemSlots.clear();
    }

    public void selectSlots(int minSlot, int maxSlot) {
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            InventoryHandler inventoryHandler = this.getInventoryHandler();
            if (slot >= inventoryHandler.getSlots()) continue;
            ItemStack stackInSlot = inventoryHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty()) {
                if (this.ignoreNbt) {
                    Item item = stackInSlot.getItem();
                    this.addSlotItem(slot, item);
                    continue;
                }
                this.addSlotStack(slot, stackInSlot);
                continue;
            }
            Item filterItem = inventoryHandler.getFilterItem(slot);
            if (filterItem == Items.AIR) continue;
            if (this.ignoreNbt) {
                this.addSlotItem(slot, filterItem);
                continue;
            }
            this.addSlotStack(slot, new ItemStack((ItemLike)filterItem));
        }
        this.serializeFilterItems();
    }

    private InventoryHandler getInventoryHandler() {
        return this.inventoryHandlerSupplier.get();
    }

    private void addSlotItem(int slot, Item item) {
        this.slotFilterItems.put(slot, item);
        this.filterItemSlots.computeIfAbsent(item, k -> {
            this.onItemAdded.accept((Item)k);
            return new TreeSet();
        }).add(slot);
    }

    private void addSlotStack(int slot, ItemStack stack) {
        ItemStackKey isk = ItemStackKey.of(stack);
        this.slotFilterStacks.put(slot, isk);
        int stackHash = isk.hashCode();
        this.filterStackSlots.computeIfAbsent(stackHash, k -> {
            this.onStackAdded.accept(stackHash);
            return new TreeSet();
        }).add(slot);
    }

    public void selectSlot(int slotNumber) {
        this.selectSlots(slotNumber, slotNumber + 1);
    }

    public void unselectSlot(int slotNumber) {
        this.unselectFilterItemSlot(slotNumber);
        this.unselectFilterStackSlot(slotNumber);
        this.serializeFilterItems();
    }

    private void unselectFilterItemSlot(int slotNumber) {
        if (!this.slotFilterItems.containsKey(slotNumber)) {
            return;
        }
        Item item = this.slotFilterItems.remove(slotNumber);
        Set<Integer> itemSlots = this.filterItemSlots.get(item);
        itemSlots.remove(slotNumber);
        if (itemSlots.isEmpty()) {
            this.filterItemSlots.remove(item);
            this.onItemRemoved.accept(item);
        }
    }

    private void unselectFilterStackSlot(int slotNumber) {
        if (!this.slotFilterStacks.containsKey(slotNumber)) {
            return;
        }
        ItemStackKey isk = this.slotFilterStacks.remove(slotNumber);
        int stackHash = isk.hashCode();
        Set<Integer> stackSlots = this.filterStackSlots.get(stackHash);
        stackSlots.remove(slotNumber);
        if (stackSlots.isEmpty()) {
            this.filterStackSlots.remove(stackHash);
            this.onStackRemoved.accept(stackHash);
        }
    }

    public boolean ignoresNbt() {
        return this.ignoreNbt;
    }

    public void setIgnoreNbt(boolean ignoreNbt) {
        if (this.ignoreNbt == ignoreNbt) {
            return;
        }
        Set<Integer> slotIndexes = this.getSlotIndexes();
        if (this.ignoreNbt && !ignoreNbt) {
            this.slotFilterItems.forEach((slot, item) -> {
                ItemStack stack = this.inventoryHandlerSupplier.get().getStackInSlot((int)slot);
                if (stack.isEmpty()) {
                    stack = new ItemStack((ItemLike)item);
                }
                this.addSlotStack((int)slot, stack);
            });
            this.unselectAllFilterItemSlots();
        } else {
            this.slotFilterStacks.forEach((slot, isk) -> this.addSlotItem((int)slot, isk.getStack().getItem()));
            this.unselectAllFilteStackSlots();
        }
        this.serializeFilterItems();
        this.ignoreNbt = ignoreNbt;
        this.serializeIgnoreNbt();
        slotIndexes.forEach(this::selectSlot);
    }

    private void serializeIgnoreNbt() {
        this.categoryNbt.putBoolean(IGNORE_NBT_TAG, this.ignoreNbt);
        this.saveNbt.accept(this.categoryNbt);
    }

    private void serializeFilterItems() {
        NBTHelper.putMap(this.categoryNbt, SLOT_FILTER_ITEMS_TAG, this.slotFilterItems, String::valueOf, i -> StringTag.valueOf((String)BuiltInRegistries.ITEM.getKey(i).toString()));
        NBTHelper.putMap(this.categoryNbt, SLOT_FILTER_STACKS_TAG, this.slotFilterStacks, String::valueOf, isk -> isk.stack().isEmpty() ? new CompoundTag() : NBTHelper.serializeStackToTag(isk.stack()).orElse((Tag)new CompoundTag()));
        this.saveNbt.accept(this.categoryNbt);
    }

    @Override
    public void reloadFrom(CompoundTag categoryNbt) {
        this.categoryNbt = categoryNbt;
        this.slotFilterItems.clear();
        this.filterItemSlots.clear();
        this.slotFilterStacks.clear();
        this.filterStackSlots.clear();
        this.deserialize();
    }

    @Override
    public void overwriteWith(MemorySettingsCategory otherCategory) {
        this.unselectAllSlots();
        this.ignoreNbt = otherCategory.ignoreNbt;
        if (this.ignoreNbt) {
            this.overwriteFilterItems(otherCategory);
        } else {
            this.overwriteFilterStacks(otherCategory);
        }
        this.serializeIgnoreNbt();
        this.serializeFilterItems();
    }

    private void overwriteFilterStacks(MemorySettingsCategory otherCategory) {
        InventoryHandler inventoryHandler = this.getInventoryHandler();
        otherCategory.slotFilterStacks.forEach((slot, isk) -> {
            if (slot >= inventoryHandler.getSlots()) {
                return;
            }
            ItemStack stackInSlot = inventoryHandler.getStackInSlot((int)slot);
            if (stackInSlot.isEmpty() || otherCategory.matchesFilter((int)slot, stackInSlot)) {
                this.addSlotStack((int)slot, isk.getStack());
            }
        });
    }

    private void overwriteFilterItems(MemorySettingsCategory otherCategory) {
        InventoryHandler inventoryHandler = this.getInventoryHandler();
        otherCategory.slotFilterItems.forEach((slot, item) -> {
            if (slot >= inventoryHandler.getSlots()) {
                return;
            }
            ItemStack stackInSlot = inventoryHandler.getStackInSlot((int)slot);
            if (stackInSlot.isEmpty() || otherCategory.matchesFilter((int)slot, stackInSlot)) {
                this.addSlotItem((int)slot, (Item)item);
            }
        });
    }

    public Set<Integer> getSlotIndexes() {
        HashSet<Integer> slots = new HashSet<Integer>(this.slotFilterItems.keySet());
        slots.addAll(this.slotFilterStacks.keySet());
        return slots;
    }

    public Map<Item, Set<Integer>> getFilterItemSlots() {
        return this.filterItemSlots;
    }

    public Map<Integer, Set<Integer>> getFilterStackSlots() {
        return this.filterStackSlots;
    }

    public boolean matchesFilter(ItemStack stack) {
        return this.filterItemSlots.containsKey(stack.getItem()) || !this.filterStackSlots.isEmpty() && this.filterStackSlots.containsKey(ItemStack.hashItemAndComponents((ItemStack)stack));
    }

    public void registerListeners(Consumer<Item> onItemAdded, Consumer<Item> onItemRemoved, Consumer<Integer> onStackAdded, Consumer<Integer> onStackRemoved) {
        this.onItemAdded = onItemAdded;
        this.onItemRemoved = onItemRemoved;
        this.onStackAdded = onStackAdded;
        this.onStackRemoved = onStackRemoved;
    }

    public void unregisterListeners() {
        this.onItemAdded = i -> {};
        this.onItemRemoved = i -> {};
        this.onStackAdded = i -> {};
        this.onStackRemoved = i -> {};
    }

    public void setFilter(int slot, ItemStack filter) {
        ItemStack stackInSlot;
        InventoryHandler inventoryHandler = this.getInventoryHandler();
        if (slot < inventoryHandler.getSlots() && (stackInSlot = inventoryHandler.getStackInSlot(slot)).isEmpty()) {
            if (this.ignoreNbt) {
                Item item = filter.getItem();
                this.addSlotItem(slot, item);
            } else {
                this.addSlotStack(slot, filter);
            }
        }
        this.serializeFilterItems();
    }

    @Override
    public boolean isLargerThanNumberOfSlots(int slots) {
        return this.slotFilterItems.keySet().stream().anyMatch(slotIndex -> slotIndex >= slots) || this.slotFilterStacks.keySet().stream().anyMatch(slotIndex -> slotIndex >= slots);
    }

    @Override
    public void copyTo(MemorySettingsCategory otherCategory, int startFromSlot, int slotOffset) {
        this.slotFilterItems.forEach((slotIndex, item) -> {
            if (slotIndex < startFromSlot) {
                return;
            }
            otherCategory.slotFilterItems.put(slotIndex + slotOffset, (Item)item);
        });
        this.slotFilterStacks.forEach((slotIndex, isk) -> {
            if (slotIndex < startFromSlot) {
                return;
            }
            otherCategory.slotFilterStacks.put(slotIndex + slotOffset, (ItemStackKey)isk);
        });
        otherCategory.serializeFilterItems();
    }

    @Override
    public void deleteSlotSettingsFrom(int slotIndex) {
        this.slotFilterItems.entrySet().removeIf(e -> (Integer)e.getKey() >= slotIndex);
        this.slotFilterStacks.entrySet().removeIf(e -> (Integer)e.getKey() >= slotIndex);
        this.serializeFilterItems();
    }
}

