/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.Slot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class ContentsFilterLogicContainer
extends FilterLogicContainer<ContentsFilterLogic> {
    private static final String DATA_CONTENTS_FILTER_TYPE = "contentsFilterType";

    public ContentsFilterLogicContainer(Supplier<ContentsFilterLogic> filterLogic, IServerUpdater serverUpdater, Consumer<Slot> addSlot) {
        super(filterLogic, serverUpdater, addSlot);
        if (this.getFilterType() == ContentsFilterType.STORAGE) {
            this.getFilterSlots().forEach(s -> s.setEnabled(false));
        }
    }

    public void setFilterType(ContentsFilterType depositFilterType) {
        ((ContentsFilterLogic)this.filterLogic.get()).setDepositFilterType(depositFilterType);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundTag(), DATA_CONTENTS_FILTER_TYPE, depositFilterType));
    }

    @Override
    public boolean handlePacket(CompoundTag data) {
        if (this.isDifferentFilterLogicsData(data)) {
            return false;
        }
        data.getString(DATA_CONTENTS_FILTER_TYPE).ifPresent(typeName -> this.setFilterType(ContentsFilterType.fromName(typeName)));
        return super.handlePacket(data);
    }

    public ContentsFilterType getFilterType() {
        return ((ContentsFilterLogic)this.filterLogic.get()).getFilterType();
    }
}

