/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pump;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IServerUpdater;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FluidFilterContainer {
    private final Player player;
    private final IServerUpdater serverUpdater;
    private final Supplier<FluidFilterLogic> fluidFilterLogic;
    private static final String DATA_FLUID = "setFluid";

    public FluidFilterContainer(Player player, IServerUpdater serverUpdater, Supplier<FluidFilterLogic> fluidFilterLogic) {
        this.player = player;
        this.serverUpdater = serverUpdater;
        this.fluidFilterLogic = fluidFilterLogic;
    }

    public FluidStack getFluid(int index) {
        return this.fluidFilterLogic.get().getFluid(index);
    }

    public void setFluid(int index, FluidStack fluid) {
        this.fluidFilterLogic.get().setFluid(index, fluid);
        this.serverUpdater.sendDataToServer(() -> this.serializeSetFluidData(index, fluid));
    }

    private CompoundTag serializeSetFluidData(int index, FluidStack fluid) {
        CompoundTag ret = new CompoundTag();
        CompoundTag fluidNbt = new CompoundTag();
        fluidNbt.putInt("index", index);
        fluidNbt.put("fluid", NBTHelper.serializeFluidToTag(fluid).orElse((Tag)new CompoundTag()));
        ret.put(DATA_FLUID, (Tag)fluidNbt);
        return ret;
    }

    public boolean handlePacket(CompoundTag data) {
        if (data.contains(DATA_FLUID)) {
            data.getCompound(DATA_FLUID).ifPresent(fluidData -> {
                FluidStack fluid = NBTHelper.deserializeFluidFromTag((Tag)fluidData.getCompoundOrEmpty("fluid")).orElse(FluidStack.EMPTY);
                this.setFluid(fluidData.getIntOr("index", 0), fluid);
            });
            return true;
        }
        return false;
    }

    public int getNumberOfFluidFilters() {
        return this.fluidFilterLogic.get().getNumberOfFluidFilters();
    }

    public void slotClick(int index) {
        ItemStack carried = this.player.containerMenu.getCarried();
        if (carried.isEmpty()) {
            this.setFluid(index, FluidStack.EMPTY);
            return;
        }
        CapabilityHelper.runOnCapability(carried, Capabilities.FluidHandler.ITEM, null, itemFluidHandler -> {
            FluidStack containedFluid = itemFluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            if (!containedFluid.isEmpty()) {
                this.setFluid(index, containedFluid);
            }
        });
    }
}

