/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.util.SetCodec;

public class CodecHelper {
    public static final Codec<ItemStack> OVERSIZED_ITEM_STACK_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(p_330103_ -> p_330103_.components.asPatch())).apply((Applicative)instance, ItemStack::new)));
    public static final PrimitiveCodec<Integer> STRING_ENCODED_INT = new PrimitiveCodec<Integer>(){

        public <T> DataResult<Integer> read(DynamicOps<T> ops, T input) {
            return ops.getStringValue(input).map(s -> {
                if (s.startsWith("i")) {
                    return Integer.parseInt(s.substring(1));
                }
                return Integer.parseInt(s);
            });
        }

        public <T> T write(DynamicOps<T> ops, Integer value) {
            return (T)ops.createString("i" + value);
        }

        public String toString() {
            return "Int";
        }
    };

    private CodecHelper() {
    }

    public static <T> Codec<Set<T>> setOf(Codec<T> elementCodec) {
        return new SetCodec<T>(elementCodec);
    }
}

