/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.crafting.CustomShapelessRecipe;

public class RecipeHelper {
    private static final int MAX_FOLLOW_UP_COMPACTING_RECIPES = 30;
    @Nullable
    private static RecipeCache clientCache = null;
    @Nullable
    private static RecipeCache serverCache = null;
    private static RecipeMap RECIPE_MAP = RecipeMap.EMPTY;

    public static void setRecipes(RecipeMap recipeMap) {
        RECIPE_MAP = recipeMap;
    }

    private RecipeHelper() {
    }

    public static void setLevel(Level l) {
        RecipeHelper.getCache().setLevel(l);
    }

    public static void clearListeners() {
        RecipeHelper.runOnCache(cache -> cache.recipeChangeListeners.list.clear());
    }

    private static void runOnCache(Consumer<RecipeCache> consumer) {
        consumer.accept(RecipeHelper.getCache());
    }

    private static RecipeCache getCache() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            if (serverCache == null) {
                serverCache = new RecipeCache();
            }
            return serverCache;
        }
        if (clientCache == null) {
            clientCache = new RecipeCache();
        }
        return clientCache;
    }

    private static <T> T getFromCache(Function<RecipeCache, T> getter, T defaultValue) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return serverCache == null ? defaultValue : getter.apply(serverCache);
        }
        return clientCache == null ? defaultValue : getter.apply(clientCache);
    }

    public static void addRecipeChangeListener(Runnable runnable) {
        RecipeHelper.runOnCache(cache -> cache.addRecipeChangeListener(runnable));
    }

    public static void onRecipesUpdated(RecipesReceivedEvent event) {
        RecipeHelper.runOnCache(cache -> {
            cache.clearCache();
            cache.recipeChangeListeners.notifyAllListeners();
        });
    }

    public static void onDataPackSync(OnDatapackSyncEvent event) {
        RecipeHelper.runOnCache(cache -> {
            cache.clearCache();
            cache.recipeChangeListeners.notifyAllListeners();
        });
        event.sendRecipes(new RecipeType[]{RecipeType.CRAFTING, RecipeType.STONECUTTING});
    }

    private static Optional<Level> getLevel() {
        return RecipeHelper.getFromCache(cache -> Optional.ofNullable(cache.level == null ? null : (Level)cache.level.get()), Optional.empty());
    }

    private static Set<CompactingShape> getCompactingShapes(ItemStack stack) {
        return RecipeHelper.getLevel().map(w -> {
            HashSet<CompactingShape> compactingShapes = new HashSet<CompactingShape>();
            RecipeHelper.getCompactingShape(stack, w, 2, 2, CompactingShape.TWO_BY_TWO_UNCRAFTABLE, CompactingShape.TWO_BY_TWO).ifPresent(compactingShapes::add);
            RecipeHelper.getCompactingShape(stack, w, 3, 3, CompactingShape.THREE_BY_THREE_UNCRAFTABLE, CompactingShape.THREE_BY_THREE).ifPresent(compactingShapes::add);
            if (compactingShapes.isEmpty()) {
                compactingShapes.add(CompactingShape.NONE);
            }
            return compactingShapes;
        }).orElse(Collections.emptySet());
    }

    private static Optional<CompactingShape> getCompactingShape(ItemStack stack, Level w, int width, int height, CompactingShape uncraftableShape, CompactingShape shape) {
        CompactingResult compactingResult = RecipeHelper.getCompactingResult(stack, w, width, height);
        if (!compactingResult.getResult().isEmpty()) {
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)compactingResult.getResult())) {
                return Optional.empty();
            }
            if (RecipeHelper.isPartOfCompactingLoop(stack, compactingResult.getResult(), w)) {
                return Optional.empty();
            }
            if (RecipeHelper.uncompactMatchesItem(compactingResult.getResult(), w, stack, width * height)) {
                return Optional.of(uncraftableShape);
            }
            return Optional.of(shape);
        }
        return Optional.empty();
    }

    private static boolean isPartOfCompactingLoop(ItemStack firstCompacted, ItemStack firstCompactResult, Level w) {
        int iterations = 0;
        HashSet<Integer> compactedItemHashes = new HashSet<Integer>();
        LinkedList<ItemStack> itemsToCompact = new LinkedList<ItemStack>();
        itemsToCompact.add(firstCompactResult);
        while (!itemsToCompact.isEmpty()) {
            ItemStack itemToCompact = (ItemStack)itemsToCompact.poll();
            ItemStack compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 2, 2).getResult();
            if (!compactingResultStack.isEmpty()) {
                if (ItemStack.isSameItemSameComponents((ItemStack)compactingResultStack, (ItemStack)firstCompacted)) {
                    return true;
                }
                if (compactedItemHashes.contains(ItemStack.hashItemAndComponents((ItemStack)compactingResultStack))) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack);
            }
            if (!(compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 3, 3).getResult()).isEmpty()) {
                if (ItemStack.isSameItemSameComponents((ItemStack)compactingResultStack, (ItemStack)firstCompacted)) {
                    return true;
                }
                if (compactedItemHashes.contains(ItemStack.hashItemAndComponents((ItemStack)compactingResultStack))) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack);
            }
            compactedItemHashes.add(ItemStack.hashItemAndComponents((ItemStack)itemToCompact));
            if (++iterations <= 30) continue;
            return true;
        }
        return false;
    }

    private static boolean uncompactMatchesItem(ItemStack itemToUncompact, Level w, ItemStack itemToMatch, int count) {
        for (ItemStack uncompactResult : RecipeHelper.getUncompactResultItems(w, itemToUncompact)) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)uncompactResult, (ItemStack)itemToMatch) || uncompactResult.getCount() != count) continue;
            return true;
        }
        return false;
    }

    public static UncompactingResult getUncompactingResult(ItemStack uncompactedItem) {
        return RecipeHelper.getFromCache(cache -> cache.getUncompactingResults().computeIfAbsent(ItemStack.hashItemAndComponents((ItemStack)uncompactedItem), k -> RecipeHelper.getLevel().map(w -> {
            for (ItemStack uncompactResultItem : RecipeHelper.getUncompactResultItems(w, uncompactedItem)) {
                if (uncompactResultItem.getCount() == 9) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)RecipeHelper.getCompactingResult(uncompactResultItem, 3, 3).getResult(), (ItemStack)uncompactedItem)) continue;
                    return new UncompactingResult(uncompactResultItem, CompactingShape.THREE_BY_THREE_UNCRAFTABLE);
                }
                if (uncompactResultItem.getCount() != 4 || !ItemStack.isSameItemSameComponents((ItemStack)RecipeHelper.getCompactingResult(uncompactResultItem, 2, 2).getResult(), (ItemStack)uncompactedItem)) continue;
                return new UncompactingResult(uncompactResultItem, CompactingShape.TWO_BY_TWO_UNCRAFTABLE);
            }
            return UncompactingResult.EMPTY;
        }).orElse(UncompactingResult.EMPTY)), UncompactingResult.EMPTY);
    }

    private static List<ItemStack> getUncompactResultItems(Level w, ItemStack itemToUncompact) {
        CraftingContainer craftingInventory = RecipeHelper.getFilledCraftingInventory(itemToUncompact, 1, 1);
        return RecipeHelper.safeGetRecipesFor(RecipeType.CRAFTING, craftingInventory.asCraftInput(), w).stream().map(r -> ((CraftingRecipe)r.value()).assemble((RecipeInput)craftingInventory.asCraftInput(), (HolderLookup.Provider)w.registryAccess())).toList();
    }

    public static CompactingResult getCompactingResult(ItemStack stack, CompactingShape shape) {
        if (shape == CompactingShape.TWO_BY_TWO_UNCRAFTABLE || shape == CompactingShape.TWO_BY_TWO) {
            return RecipeHelper.getCompactingResult(stack, 2, 2);
        }
        if (shape == CompactingShape.THREE_BY_THREE_UNCRAFTABLE || shape == CompactingShape.THREE_BY_THREE) {
            return RecipeHelper.getCompactingResult(stack, 3, 3);
        }
        return CompactingResult.EMPTY;
    }

    public static CompactingResult getCompactingResult(ItemStack stack, int width, int height) {
        return RecipeHelper.getLevel().map(w -> RecipeHelper.getCompactingResult(stack, w, width, height)).orElse(CompactingResult.EMPTY);
    }

    private static CompactingResult getCompactingResult(ItemStack stack, Level level, int width, int height) {
        return RecipeHelper.getFromCache(cache -> RecipeHelper.getCompactingResult(stack, level, width, height, cache.getCompactingResults()), CompactingResult.EMPTY);
    }

    private static CompactingResult getCompactingResult(ItemStack stack, Level level, int width, int height, Map<CompactedItem, CompactingResult> cachedCompactingResults) {
        CompactedItem compactedItem = new CompactedItem(stack, width, height);
        if (cachedCompactingResults.containsKey(compactedItem)) {
            return cachedCompactingResults.get(compactedItem);
        }
        CraftingContainer craftingInventory = RecipeHelper.getFilledCraftingInventory(stack, width, height);
        List compactingRecipes = RecipeHelper.safeGetRecipesFor(RecipeType.CRAFTING, craftingInventory.asCraftInput(), level);
        if (compactingRecipes.isEmpty()) {
            cachedCompactingResults.put(compactedItem, CompactingResult.EMPTY);
            return CompactingResult.EMPTY;
        }
        if (compactingRecipes.size() == 1) {
            return RecipeHelper.cacheAndGetCompactingResult(compactedItem, (CraftingRecipe)compactingRecipes.getFirst().value(), craftingInventory);
        }
        for (RecipeHolder recipeHolder : compactingRecipes) {
            CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
            ItemStack result = recipe.assemble((RecipeInput)craftingInventory.asCraftInput(), (HolderLookup.Provider)level.registryAccess());
            if (!RecipeHelper.uncompactMatchesItem(result, level, stack, width * height)) continue;
            return RecipeHelper.cacheAndGetCompactingResult(compactedItem, recipe, craftingInventory, result);
        }
        return RecipeHelper.cacheAndGetCompactingResult(compactedItem, (CraftingRecipe)compactingRecipes.getFirst().value(), craftingInventory);
    }

    private static CompactingResult cacheAndGetCompactingResult(CompactedItem compactedItem, CraftingRecipe recipe, CraftingContainer craftingInventory) {
        return RecipeHelper.getLevel().map(level -> RecipeHelper.cacheAndGetCompactingResult(compactedItem, recipe, craftingInventory, recipe.assemble((RecipeInput)craftingInventory.asCraftInput(), (HolderLookup.Provider)level.registryAccess()))).orElse(CompactingResult.EMPTY);
    }

    private static CompactingResult cacheAndGetCompactingResult(CompactedItem compactedItem, CraftingRecipe recipe, CraftingContainer craftingInventory, ItemStack result) {
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
        recipe.getRemainingItems(craftingInventory.asCraftInput()).forEach(stack -> {
            if (!stack.isEmpty()) {
                remainingItems.add((ItemStack)stack);
            }
        });
        CompactingResult compactingResult = new CompactingResult(result, remainingItems);
        return RecipeHelper.getFromCache(cache -> {
            if (!result.isEmpty()) {
                cache.getCompactingResults().put(compactedItem, compactingResult);
            }
            return compactingResult;
        }, compactingResult);
    }

    private static CraftingContainer getFilledCraftingInventory(ItemStack stack, int width, int height) {
        TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, width, height);
        for (int i = 0; i < craftinginventory.getContainerSize(); ++i) {
            craftinginventory.setItem(i, stack.copyWithCount(1));
        }
        return craftinginventory;
    }

    public static RecipePropertySet getPropertySet(ResourceKey<RecipePropertySet> acceptedInputs) {
        return RecipeHelper.getLevel().map(level -> level.recipeAccess().propertySet(acceptedInputs)).orElse(RecipePropertySet.EMPTY);
    }

    public static <T extends AbstractCookingRecipe> Optional<RecipeHolder<T>> getCookingRecipe(ItemStack stack, RecipeType<T> recipeType) {
        return RecipeHelper.getLevel().flatMap(w -> RecipeHelper.safeGetRecipeFor(recipeType, new SingleRecipeInput(stack), w, null));
    }

    public static Set<CompactingShape> getItemCompactingShapes(ItemStack stack) {
        return RecipeHelper.getFromCache(cache -> cache.getItemCompactingShapes(stack), Collections.emptySet());
    }

    public static <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> getRecipesOfType(RecipeType<T> recipeType) {
        return RecipeHelper.getLevel().map(level -> RecipeHelper.safeGetRecipesOfType(recipeType, level)).orElse(Collections.emptyList());
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getRecipesOfType(RecipeType<T> recipeType, I inventory) {
        return RecipeHelper.getLevel().map(level -> RecipeHelper.safeGetRecipesFor(recipeType, inventory, level)).orElse(Collections.emptyList());
    }

    public static <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> safeGetRecipeFor(RecipeType<T> recipeType, I inventory, Level level, @Nullable ResourceKey<Recipe<?>> recipeId) {
        try {
            if (!(level instanceof ServerLevel)) {
                SophisticatedCore.LOGGER.error("safeGetRecipeFor called on client side, returning empty optional");
                return Optional.empty();
            }
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.recipeAccess().getRecipeFor(recipeType, inventory, level, recipeId);
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Error while getting recipe ", (Throwable)e);
            return Optional.empty();
        }
    }

    public static <I extends RecipeInput, R extends Recipe<I>> Collection<RecipeHolder<R>> safeGetRecipesOfType(RecipeType<R> recipeType, Level level) {
        try {
            RecipeMap recipeMap = RecipeHelper.getRecipeMap(level);
            return recipeMap.byType(recipeType);
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Error while getting recipes of type ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static RecipeMap getRecipeMap(Level level) {
        RecipeMap recipeMap;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            recipeMap = serverLevel.recipeAccess().recipeMap();
        } else {
            recipeMap = RECIPE_MAP;
        }
        return recipeMap;
    }

    public static <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> safeGetRecipesFor(RecipeType<T> recipeType, I inventory, Level level) {
        try {
            return RecipeHelper.getRecipeMap(level).getRecipesFor(recipeType, inventory, level).toList();
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Error while getting recipe ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static Collection<Optional<Ingredient>> getIngredients(Recipe<?> recipe) {
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            return shapedRecipe.pattern.ingredients();
        }
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            return shapelessRecipe.ingredients.stream().map(Optional::of).toList();
        }
        if (recipe instanceof CustomShapelessRecipe) {
            CustomShapelessRecipe customShapelessRecipe = (CustomShapelessRecipe)recipe;
            return customShapelessRecipe.getIngredients().stream().map(Optional::of).toList();
        }
        return Collections.emptyList();
    }

    public static HolderLookup<Item> getItemLookup() {
        return (HolderLookup)RecipeHelper.getLevel().map(level -> level.registryAccess().lookupOrThrow(Registries.ITEM)).orElseThrow();
    }

    public static ContextMap getContextMap() {
        return RecipeHelper.getLevel().map(SlotDisplayContext::fromLevel).orElse(ContextMap.EMPTY);
    }

    private static class RecipeCache {
        private final Cache<Integer, Set<CompactingShape>> itemCompactingShapes = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        private final Map<CompactedItem, CompactingResult> compactingResults = new HashMap<CompactedItem, CompactingResult>();
        private final Map<Integer, UncompactingResult> uncompactingResults = new HashMap<Integer, UncompactingResult>();
        private final RecipeChangeListenerList recipeChangeListeners = new RecipeChangeListenerList();
        private WeakReference<Level> level;

        private RecipeCache() {
        }

        public void addRecipeChangeListener(Runnable runnable) {
            this.recipeChangeListeners.add(runnable);
        }

        public Map<Integer, UncompactingResult> getUncompactingResults() {
            return this.uncompactingResults;
        }

        public Map<CompactedItem, CompactingResult> getCompactingResults() {
            return this.compactingResults;
        }

        public Set<CompactingShape> getItemCompactingShapes(ItemStack stack) {
            int hash = ItemStack.hashItemAndComponents((ItemStack)stack);
            Set<CompactingShape> compactingShapes = (Set<CompactingShape>)this.itemCompactingShapes.getIfPresent((Object)hash);
            if (compactingShapes == null) {
                SophisticatedCore.LOGGER.debug("Compacting shapes not found in cache for \"{}\" - querying recipes to get these", (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()));
                compactingShapes = RecipeHelper.getCompactingShapes(stack);
                this.itemCompactingShapes.put((Object)hash, compactingShapes);
            }
            return compactingShapes;
        }

        private void clearCache() {
            this.compactingResults.clear();
            this.uncompactingResults.clear();
            this.itemCompactingShapes.invalidateAll();
        }

        public void setLevel(Level l) {
            this.level = new WeakReference<Level>(l);
        }
    }

    public static class CompactingResult {
        public static final CompactingResult EMPTY = new CompactingResult(ItemStack.EMPTY, Collections.emptyList());
        private final ItemStack result;
        private final List<ItemStack> remainingItems;

        public CompactingResult(ItemStack result, List<ItemStack> remainingItems) {
            this.result = result;
            this.remainingItems = remainingItems;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public List<ItemStack> getRemainingItems() {
            return this.remainingItems;
        }
    }

    public static class UncompactingResult {
        public static final UncompactingResult EMPTY = new UncompactingResult(ItemStack.EMPTY, CompactingShape.NONE);
        private final ItemStack result;
        private final CompactingShape compactUsingShape;

        public UncompactingResult(ItemStack result, CompactingShape compactUsingShape) {
            this.result = result.copyWithCount(1);
            this.compactUsingShape = compactUsingShape;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public CompactingShape getCompactUsingShape() {
            return this.compactUsingShape;
        }
    }

    public static enum CompactingShape {
        NONE(false, 0),
        THREE_BY_THREE(false, 9),
        TWO_BY_TWO(false, 4),
        THREE_BY_THREE_UNCRAFTABLE(true, 9),
        TWO_BY_TWO_UNCRAFTABLE(true, 4);

        private final int numberOfIngredients;
        private final boolean uncraftable;

        private CompactingShape(boolean uncraftable, int numberOfIngredients) {
            this.uncraftable = uncraftable;
            this.numberOfIngredients = numberOfIngredients;
        }

        public boolean isUncraftable() {
            return this.uncraftable;
        }

        public int getNumberOfIngredients() {
            return this.numberOfIngredients;
        }
    }

    private static class CompactedItem {
        private final ItemStack item;
        private final int itemHash;
        private final int width;
        private final int height;

        private CompactedItem(ItemStack item, int width, int height) {
            this.item = item.copyWithCount(1);
            this.width = width;
            this.height = height;
            this.itemHash = ItemStack.hashItemAndComponents((ItemStack)item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompactedItem that = (CompactedItem)o;
            return this.width == that.width && this.height == that.height && ItemStack.isSameItemSameComponents((ItemStack)this.item, (ItemStack)that.item);
        }

        public int hashCode() {
            return Objects.hash(this.itemHash, this.width, this.height);
        }
    }

    private static class RecipeChangeListenerList {
        private final List<WeakReference<Runnable>> list = new CopyOnWriteArrayList<WeakReference<Runnable>>();

        private RecipeChangeListenerList() {
        }

        public void add(Runnable runnable) {
            this.list.add(new WeakReference<Runnable>(runnable));
        }

        public void notifyAllListeners() {
            this.list.removeIf(ref -> {
                Runnable runnable = (Runnable)ref.get();
                if (runnable != null) {
                    runnable.run();
                    return false;
                }
                return true;
            });
        }
    }
}

