/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.fluid.data;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function6;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public interface ClientFluidProperties {
    public ResourceLocation still(@Nullable BlockAndTintGetter var1, @Nullable BlockPos var2, @Nullable FluidState var3);

    public ResourceLocation flowing(@Nullable BlockAndTintGetter var1, @Nullable BlockPos var2, @Nullable FluidState var3);

    public ResourceLocation overlay(@Nullable BlockAndTintGetter var1, @Nullable BlockPos var2, @Nullable FluidState var3);

    public ResourceLocation screenOverlay();

    default public void renderOverlay(Minecraft minecraft, PoseStack stack, MultiBufferSource source) {
        ResourceLocation texture = this.screenOverlay();
        if (texture != null) {
            LocalPlayer player = minecraft.player;
            BlockPos blockpos = BlockPos.containing((double)player.getX(), (double)player.getEyeY(), (double)player.getZ());
            float brightness = LightTexture.getBrightness((DimensionType)player.level().dimensionType(), (int)player.level().getMaxLocalRawBrightness(blockpos));
            int color = ARGB.colorFromFloat((float)0.1f, (float)brightness, (float)brightness, (float)brightness);
            float a = -player.getYRot() / 64.0f;
            float b = player.getXRot() / 64.0f;
            Matrix4f matrix = stack.last().pose();
            VertexConsumer consumer = source.getBuffer(RenderType.blockScreenEffect((ResourceLocation)texture));
            consumer.addVertex(matrix, -1.0f, -1.0f, -0.5f).setUv(4.0f + a, 4.0f + b).setColor(color);
            consumer.addVertex(matrix, 1.0f, -1.0f, -0.5f).setUv(0.0f + a, 4.0f + b).setColor(color);
            consumer.addVertex(matrix, 1.0f, 1.0f, -0.5f).setUv(0.0f + a, 0.0f + b).setColor(color);
            consumer.addVertex(matrix, -1.0f, 1.0f, -0.5f).setUv(4.0f + a, 0.0f + b).setColor(color);
        }
    }

    public int tintColor(@Nullable BlockAndTintGetter var1, @Nullable BlockPos var2, @Nullable FluidState var3);

    default public boolean renderFluid(BlockPos pos, BlockAndTintGetter world, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, Function<ResourceLocation, TextureAtlasSprite> sprites) {
        return false;
    }

    default public Vector4f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector4f fluidFogColor) {
        return fluidFogColor;
    }

    default public FogData modifyFogRender(Camera camera, float renderDistance, float partialTick, FogData data) {
        return data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Function3<BlockAndTintGetter, BlockPos, FluidState, ResourceLocation> still = (a, b, c) -> null;
        private Function3<BlockAndTintGetter, BlockPos, FluidState, ResourceLocation> flowing = (a, b, c) -> null;
        private Function3<BlockAndTintGetter, BlockPos, FluidState, ResourceLocation> overlay = (a, b, c) -> null;
        private ResourceLocation screenOverlay = null;
        private Function3<BlockAndTintGetter, BlockPos, FluidState, Integer> tintColor = (a, b, c) -> -1;
        private Function6<BlockPos, BlockAndTintGetter, VertexConsumer, BlockState, FluidState, Function<ResourceLocation, TextureAtlasSprite>, Boolean> renderFluid = (a, b, c, d, e, f) -> false;

        public Builder still(ResourceLocation still) {
            this.still = (a, b, c) -> still;
            return this;
        }

        public Builder flowing(ResourceLocation flowing) {
            this.flowing = (a, b, c) -> flowing;
            return this;
        }

        public Builder overlay(ResourceLocation overlay) {
            this.overlay = (a, b, c) -> overlay;
            return this;
        }

        public Builder screenOverlay(ResourceLocation screenOverlay) {
            this.screenOverlay = screenOverlay;
            return this;
        }

        public Builder tintColor(Function3<BlockAndTintGetter, BlockPos, FluidState, Integer> tintColor) {
            this.tintColor = tintColor;
            return this;
        }

        public Builder tintColor(int tintColor) {
            this.tintColor = (a, b, c) -> tintColor;
            return this;
        }

        public Builder renderFluid(Function6<BlockPos, BlockAndTintGetter, VertexConsumer, BlockState, FluidState, Function<ResourceLocation, TextureAtlasSprite>, Boolean> renderFluid) {
            this.renderFluid = renderFluid;
            return this;
        }

        public ClientFluidProperties build() {
            return new ClientFluidProperties(){

                @Override
                public ResourceLocation still(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, @Nullable FluidState state) {
                    return (ResourceLocation)still.apply((Object)view, (Object)pos, (Object)state);
                }

                @Override
                public ResourceLocation flowing(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, @Nullable FluidState state) {
                    return (ResourceLocation)flowing.apply((Object)view, (Object)pos, (Object)state);
                }

                @Override
                public ResourceLocation overlay(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, @Nullable FluidState state) {
                    return (ResourceLocation)overlay.apply((Object)view, (Object)pos, (Object)state);
                }

                @Override
                public ResourceLocation screenOverlay() {
                    return screenOverlay;
                }

                @Override
                public int tintColor(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, @Nullable FluidState state) {
                    return (Integer)tintColor.apply((Object)view, (Object)pos, (Object)state);
                }

                @Override
                public boolean renderFluid(BlockPos pos, BlockAndTintGetter world, VertexConsumer vertexConsumer, BlockState blockState, FluidState fluidState, Function<ResourceLocation, TextureAtlasSprite> sprites) {
                    return (Boolean)renderFluid.apply((Object)pos, (Object)world, (Object)vertexConsumer, (Object)blockState, (Object)fluidState, sprites);
                }
            };
        }
    }
}

