/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights.state;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Quadrant;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.client.highlights.HighlightHandler;
import com.teamresourceful.resourcefullib.client.highlights.base.Highlight;
import com.teamresourceful.resourcefullib.client.highlights.base.HighlightLine;
import com.teamresourceful.resourcefullib.client.highlights.state.StateVariant;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record HighlightStates(Map<List<BlockState>, Highlight> states) {
    private static final Vector3f CENTER = new Vector3f(0.5f, 0.0f, 0.5f);
    public static final Codec<BlockModelRotation> ROTATION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Quadrant.CODEC.fieldOf("x").orElse((Object)Quadrant.R0).forGetter(ignored -> Quadrant.R0), (App)Quadrant.CODEC.fieldOf("y").orElse((Object)Quadrant.R0).forGetter(ignored -> Quadrant.R0)).apply((Applicative)instance, BlockModelRotation::by));
    public static final Codec<Highlight> TRANSLATED_BOX_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HighlightHandler.HIGHLIGHT_CODEC.fieldOf("highlight").forGetter(i -> i), (App)ExtraCodecs.VECTOR3F.fieldOf("translation").orElse((Object)new Vector3f(0.0f, 0.0f, 0.0f)).forGetter(ignored -> new Vector3f(0.0f, 0.0f, 0.0f)), (App)ROTATION_CODEC.fieldOf("rotation").orElse((Object)BlockModelRotation.X0_Y0).forGetter(ignored -> BlockModelRotation.X0_Y0)).apply((Applicative)instance, HighlightStates::createBox));
    public static final Codec<Highlight> BOX_CODEC = CodecExtras.eitherRight(Codec.either(HighlightHandler.HIGHLIGHT_CODEC, TRANSLATED_BOX_CODEC));

    public static Codec<HighlightStates> codec(Block block) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(StateVariant.stateCodec(block), BOX_CODEC).fieldOf("variants").forGetter(HighlightStates::states)).apply((Applicative)instance, HighlightStates::new));
    }

    private static Highlight createBox(Highlight box, Vector3f translation, BlockModelRotation rotation) {
        if (translation.equals((Object)new Vector3f(0.0f, 0.0f, 0.0f)) && rotation.equals((Object)BlockModelRotation.X0_Y0)) {
            return box;
        }
        Highlight newBox = box.copy();
        for (HighlightLine line : newBox.lines()) {
            line.start().sub((Vector3fc)CENTER);
            line.end().sub((Vector3fc)CENTER);
            line.start().rotate((Quaternionfc)rotation.transformation().getLeftRotation());
            line.end().rotate((Quaternionfc)rotation.transformation().getLeftRotation());
            line.start().add((Vector3fc)CENTER);
            line.end().add((Vector3fc)CENTER);
            line.start().add((Vector3fc)translation);
            line.end().add((Vector3fc)translation);
            line.recalculateNormal();
        }
        return newBox;
    }
}

