/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.sysinfo.defaults;

import com.teamresourceful.resourcefullib.client.sysinfo.SystemInfo;
import com.teamresourceful.resourcefullib.client.sysinfo.SystemInfoBuilder;
import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfo;
import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfoUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.Optionull;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.util.debugchart.LocalSampleLogger;

public record MinecraftInfo() implements Consumer<SystemInfoBuilder>
{
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)Util.make((Object)new DecimalFormat("########0.000"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public static void register() {
        SystemInfo.addBuilder("Game", new MinecraftInfo());
    }

    private void tryAppendingFabric(SystemInfoBuilder builder) {
        if (ModInfoUtils.isModLoaded("fabric")) {
            ModInfo info = ModInfoUtils.getModInfo("fabric");
            builder.append("Mod Loader", info.displayName());
            builder.append("Fabric Version", info.version());
        }
    }

    private void tryAppendingQuilt(SystemInfoBuilder builder) {
        if (ModInfoUtils.isModLoaded("quilt")) {
            ModInfo info = ModInfoUtils.getModInfo("quilt");
            builder.append("Mod Loader", info.displayName());
            builder.append("Quilt Version", info.version());
        }
    }

    private void tryAppendingForge(SystemInfoBuilder builder) {
        if (ModInfoUtils.isModLoaded("forge")) {
            ModInfo info = ModInfoUtils.getModInfo("forge");
            builder.append("Mod Loader", info.displayName());
            builder.append("Forge Version", info.version());
        }
    }

    private void tryAppendingNeoForge(SystemInfoBuilder builder) {
        if (ModInfoUtils.isModLoaded("neoforge")) {
            ModInfo info = ModInfoUtils.getModInfo("neoforge");
            builder.append("Mod Loader", info.displayName());
            builder.append("NeoForge Version", info.version());
        }
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private static String getPing(Minecraft mc) {
        LocalSampleLogger logger = mc.getDebugOverlay().getPingLogger();
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long sum = 0L;
        for (int i = 0; i < logger.capacity(); ++i) {
            long sample = logger.get(i);
            min = Math.min(min, sample);
            max = Math.max(max, sample);
            sum += sample;
        }
        return "%.2f avg ms / %d min ms / %d max ms".formatted((double)sum / (double)logger.capacity(), min, max);
    }

    @Override
    public void accept(SystemInfoBuilder builder) {
        Minecraft mc = Minecraft.getInstance();
        builder.append("Minecraft Version", SharedConstants.getCurrentVersion().name());
        builder.append("Client Brand", ClientBrandRetriever.getClientModName());
        builder.append("Language", mc.getLanguageManager().getSelected());
        this.tryAppendingFabric(builder);
        this.tryAppendingQuilt(builder);
        this.tryAppendingForge(builder);
        this.tryAppendingNeoForge(builder);
        builder.append("FPS", Minecraft.getInstance().getFps());
        builder.append("TPS", Optionull.mapOrDefault((Object)mc.getSingleplayerServer(), server -> DECIMAL_FORMAT.format(Math.min(1000.0 / ((double)MinecraftInfo.mean(server.getTickTimesNanos()) * 1.0E-6), 20.0)), (Object)"N/A"));
        builder.append("Ping", Optionull.mapOrDefault((Object)mc.getConnection(), $ -> MinecraftInfo.getPing(mc), (Object)"N/A"));
        builder.append("Connection", mc.isSingleplayer() ? "Singleplayer" : (mc.isLocalServer() ? "Singleplayer Lan" : "Multiplayer"));
        builder.append("Loaded Mods", ModInfoUtils.getLoadedMods());
    }
}

